package jfractionlab.jflOptionDialogs;


import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;

import javax.swing.JFrame;

import jfractionlab.JFractionLab;
import jfractionlab.worksheets.AdditionWSGenerator;


public class AdditionWorkSheetDialog extends WorkSheetDialog{
	static final long serialVersionUID = JFractionLab.serialVersionUID;

	public AdditionWorkSheetDialog(){
		super(false);
		lbTitle.setText(
				lang.Messages.getString("worksheets")+" : "+
				lang.Messages.getString("add_fractions")
		);
		setLocation(150, 150);
		setSize(500,300);
		setResizable(true);
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		pack();
		setVisible(true);
	}
	
	private void okAction(){
		new AdditionWSGenerator(new File(jtfFile.getText()));
		close();
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		Object obj = e.getSource();
		if (obj == btnCancel){
				close();
		}else if(obj == btnOK){
			okAction();
		}else if (obj == btnChooseFile){
			jtfFile.setText(chooseFileName());
		}
	}
	@Override
	public void keyPressed(KeyEvent event){
		int key = event.getKeyCode();
		Object obj = event.getSource();
		if(key == KeyEvent.VK_ENTER && obj == btnCancel){
			close();
		}else if(key == KeyEvent.VK_ENTER && obj == btnOK){
			okAction();
		}
	}
}