/**********************************************************************/
/* MAPPABLE.C: All remappable functions                               */
/**********************************************************************/

/*
    Copyright (C) 1996, 1997 Free Software Foundation, Inc.
    Ce programme fait partie du package JERED et est soumis, comme le
    reste du package JERED, a la Gnu General Public License version 2
    ou superieure dont voici un extrait et dont vous pouvez lire
    la totalite en consultant le fichier COPYING.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

#include <sys/types.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "jered.h"
#include "formulr.h"
#include "mappable.h"
#include "messages.h"

extern int tabsize;
extern int insert_mode;

extern int reentrant;
extern PTFORMU formmacro;
extern char vmacroname[66];

extern FILELIST *debut_liste;

void getscreensize(void);
/**********************************************************************/
int function_redraw(FICHIER *fichier, char *buffer, int position)
{
        int cursor;
        int i;
        
        
        /* save current cursor's value */
        cursor = allume_curseur(0);
        allume_curseur(cursor);
        
        endwin();
        clr_scr();
        
        getscreensize();
        
        set_jered_colors();
        
        if (fichier == NULL)
                fichier = debut_liste->fichier;
                
        clr_scr();
        
        if ((buffer != NULL) && (fichier->courante->suivante != NULL) && (fichier->courante->precedente != NULL))
                realloue_texte(fichier->courante, buffer);
                
        affiche_ecran(fichier, 0, NULL);
        
        set_refresh(OFF);
        if (fichier->ligne >= JEREDLINES)
        {
                for (i = 0; i <= (fichier->ligne - JEREDLINES + 1); i++)
                        remonter_ligne(fichier);
        }        
        affiche_status_line(fichier, fichier->colonne + fichier->premier_caractere + 1);
        affiche_help_line();
        set_refresh(ON);
        refresh();
        
        /* now we can restore the saved cursor's value */
        allume_curseur(cursor);
        
        return(0);
}
/**********************************************************************/
int function_genhelp(FICHIER *fichier, char *buffer, int position)
{
        char *fname;
        FILE *fout;
        char *msg;
        int i;

        fname = "./genhelp.je"; /* default file to create */
        fout = fopen(fname, "w+t");
        if (fout != NULL)
        {
                /* printf the header */
                fprintf(fout, message[MSG_HELPHEADER1]);
                fprintf(fout, message[MSG_HELPHEADER2]);
                
                /* print all normal keys */
                for (i = 0; i < KEY_MAX; i++)
                {
                        msg = get_keymap(i);
                        if (msg != NULL)
                                fprintf(fout, "%s: %s\n", jkey_name(i), msg);
                }
                
                /* then print all ESC keys */
                for (i = 0; i < KEY_MAX; i++)
                {
                        msg = get_keymap(i + (KEY_MAX + 1));
                        if (msg != NULL)
                                fprintf(fout, "%s: %s\n", jkey_name(i + (KEY_MAX + 1)), msg);
                }
                fclose(fout);   /* we close the file */
                
                edite_autre_fichier(fname);
                return(FICHIERSUIVANT); /* we must return this value */
        }
        else
        {
                /* we can't create the file */
                /* so we load the default help file */
                return(function_help(fichier, buffer, position));
        }
}
/**********************************************************************/
int function_help(FICHIER *fichier, char *buffer, int position)
{
        char *fname;

        fname = getenv("JEHELP");
        if (fname == NULL)
                fname = "./help.je";
                
        edite_autre_fichier(fname);
        return(FICHIERSUIVANT); /* we must return this value */
}
/**********************************************************************/
int function_command(FICHIER *fichier, char *buffer, int position)
{
        return(COMMANDE);
}
/**********************************************************************/
int function_shell(FICHIER *fichier, char *buffer, int position)
{
        return(SHELL);
}
/**********************************************************************/
int function_quit(FICHIER *fichier, char *buffer, int position)
{
        if (! fichier->saved) /* was the file modified since the last save ? */
        {
                if (confirmation(message[MSG_WANTTOQUIT]))
                        return(QUITTE);
                return(0); /* the user doesn't want to quit this file */
        }
        else
                return(QUITTE); /* no, so the user can quit without confirmation */
}
/**********************************************************************/
int function_save(FICHIER *fichier, char *buffer, int position)
{
        return(SAUVE);
}
/**********************************************************************/
int function_find(FICHIER *fichier, char *buffer, int position)
{
        return(CHERCHE);
}
/**********************************************************************/
int function_mark(FICHIER *fichier, char *buffer, int position)
{
        return(MARQUER_BLOC);
}
/**********************************************************************/
int function_unmark(FICHIER *fichier, char *buffer, int position)
{
        return(DEMARQUER_BLOC);
}
/**********************************************************************/
int function_copy(FICHIER *fichier, char *buffer, int position)
{
        return(COPIER_BLOC);
}
/**********************************************************************/
int function_remove(FICHIER *fichier, char *buffer, int position)
{
        return(SUPPRIMER_BLOC);
}
/**********************************************************************/
int function_move(FICHIER *fichier, char *buffer, int position)
{
        return(DEPLACER_BLOC);
}
/**********************************************************************/
int function_nextfile(FICHIER *fichier, char *buffer, int position)
{
        return(FICHIERSUIVANT);
}
/**********************************************************************/
int function_paragraphup(FICHIER *fichier, char *buffer, int position)
{
        return(REMONTE_PARAGRAPHE);
}
/**********************************************************************/
int function_paragraphdown(FICHIER *fichier, char *buffer, int position)
{
        return(DESCEND_PARAGRAPHE);
}
/**********************************************************************/
int function_lineup(FICHIER *fichier, char *buffer, int position)
{
        return(REMONTE_LIGNE);
}
/**********************************************************************/
int function_linedown(FICHIER *fichier, char *buffer, int position)
{
        return(DESCEND_LIGNE);
}
/**********************************************************************/
int function_pagedown(FICHIER *fichier, char *buffer, int position)
{
        return(DESCEND_PAGE);
}
/**********************************************************************/
int function_pageup(FICHIER *fichier, char *buffer, int position)
{
        return(REMONTE_PAGE);
}
/**********************************************************************/
int function_insertline(FICHIER *fichier, char *buffer, int position)
{
        if (fichier->courante->debut_marque == NOTMARKED)
                return(INSERE_LIGNE);
        else
        {
                beep();
                return(0);
        }
}
/**********************************************************************/
int function_deleteline(FICHIER *fichier, char *buffer, int position)
{
        if (fichier->courante->debut_marque == NOTMARKED)
                return(DETRUIT_LIGNE);
        else
        {
                beep();
                return(0);
        }
}
/**********************************************************************/
int function_man(FICHIER *fichier, char *buffer, int position)
{
        char word[SZBUF + 2];
        char cmd[SZBUF + 2];
        
        current_word(buffer, position, word);
        if (*word)
        {
                sprintf(cmd, "man %s", word);
                launch_external_command(cmd, NATTENDSPAS);
        }
        
        return(0);
}
/**********************************************************************/
int function_info(FICHIER *fichier, char *buffer, int position)
{
        char word[SZBUF + 2];
        char cmd[SZBUF + 2];
        
        current_word(buffer, position, word);
        if (*word)
        {
                sprintf(cmd, "info %s", word);
                launch_external_command(cmd, NATTENDSPAS);
        }
        return(0);
}
/**********************************************************************/
int function_previousword(FICHIER *fichier, char *buffer, int position)
{
        if ((fichier->colonne + fichier->premier_caractere) > 0)
        {
                do
                {
                        function_left(fichier, buffer, fichier->colonne + fichier->premier_caractere);
                }
                while (((fichier->colonne + fichier->premier_caractere) > 0) && (isspace(buffer[fichier->colonne + fichier->premier_caractere]))) ;
        }

        if ((fichier->colonne + fichier->premier_caractere) > 0)
        {
                do
                {
                        function_left(fichier, buffer, fichier->colonne + fichier->premier_caractere);
                }
                while (((fichier->colonne + fichier->premier_caractere) > 0) && (! isspace(buffer[fichier->colonne + fichier->premier_caractere]))) ;
        }

        if ((fichier->colonne + fichier->premier_caractere > 0) &&
             isspace(buffer[fichier->colonne + fichier->premier_caractere]))
                function_right(fichier, buffer, fichier->colonne + fichier->premier_caractere);

        return(0);
}
/**********************************************************************/
int function_nextword(FICHIER *fichier, char *buffer, int position)
{
        do
        {
                function_right(fichier, buffer, fichier->colonne + fichier->premier_caractere);
        }
        while (buffer[fichier->colonne + fichier->premier_caractere] && (! isspace(buffer[fichier->colonne + fichier->premier_caractere]))) ;

        if (buffer[fichier->colonne + fichier->premier_caractere])
        {
                do
                {
                        function_right(fichier, buffer, fichier->colonne + fichier->premier_caractere);
                }
                while (isspace(buffer[fichier->colonne + fichier->premier_caractere])) ;
        }
        return(0);
}
/**********************************************************************/
int function_home(FICHIER *fichier, char *buffer, int position)
{
        gauche(fichier, buffer, 0, 1);
        affiche_ecran(fichier, fichier->premier_caractere, fichier->courante);
        return(0);
}
/**********************************************************************/
int function_end(FICHIER *fichier, char *buffer, int position)
{
        droite(fichier, buffer, 0, 1);
        if (fichier->colonne + fichier->premier_caractere > (JEREDCOLS - 1))
                affiche_ecran(fichier, fichier->premier_caractere, fichier->courante);
        return(0);
}
/**********************************************************************/
int function_left(FICHIER *fichier, char *buffer, int position)
{
        if ((fichier->colonne == XMIN) && fichier->premier_caractere)
                affiche_ecran(fichier, fichier->premier_caractere - 1, fichier->courante);
        gauche(fichier, buffer, 0, 0);
        return(0);
}
/**********************************************************************/
int function_right(FICHIER *fichier, char *buffer, int position)
{
        droite(fichier, buffer, 0, 0);
        if (fichier->colonne + fichier->premier_caractere > (JEREDCOLS - 1))
                affiche_ecran(fichier, fichier->premier_caractere, fichier->courante);
        return(0);
}
/**********************************************************************/
int function_invertinsmod(FICHIER *fichier, char *buffer, int pos)
{
        inverse_insert_mode();
        return(0);
}
/**********************************************************************/
int function_cutline(FICHIER *fichier, char *buffer, int pos)
{
        /* le fichier a ete modifie */
        fichier->saved = 0;

        if ((fichier->courante->precedente != NULL) && (fichier->courante->suivante != NULL))
        {
                if (fichier->courante->debut_marque == NOTMARKED)
                {
                        if (insere_ligne(fichier, &buffer[pos], fichier->courante, fichier->courante->suivante) != NULL)
                        {
                                buffer[pos] = '\0';
                                realloue_texte(fichier->courante, buffer);
                                affiche_ecran(fichier, fichier->premier_caractere, NULL);
                        }
                        else
                                erreur(message[MSG_ERROR_MEMORY], NULL);
                }
        }
        return(0);
}
/**********************************************************************/
int function_tab(FICHIER *fichier, char *buffer, int pos)
{
        int nbspaces;           /* nbre d'espaces pour tabulation */

        /* le fichier a ete modifie */
        fichier->saved = 0;

        if ((fichier->courante->precedente != NULL) && (fichier->courante->suivante != NULL))
        {
                nbspaces = tabsize - (pos % tabsize);
                if (insert_mode == INSERT)
                        inserespace(buffer, pos, nbspaces);
                while (nbspaces--)
                {
                        droite(fichier, buffer, 1, 0);
                        if (fichier->colonne + fichier->premier_caractere > (JEREDCOLS - 1))
                                affiche_ecran(fichier, fichier->premier_caractere, fichier->courante);
                }
        }
        return(0);
}
/**********************************************************************/
int function_backtab(FICHIER *fichier, char *buffer, int pos)
{
        int nbspaces;           /* nbre d'espaces pour tabulation */

        /* le fichier a ete modifie */
        fichier->saved = 0;

        if ((fichier->courante->precedente != NULL) && (fichier->courante->suivante != NULL))
        {
                nbspaces = (pos % tabsize);
                if (! nbspaces)
                        nbspaces = tabsize;
                while (nbspaces--)
                {
                        gauche(fichier, buffer, 1, 0);
                        affiche_ecran(fichier, fichier->premier_caractere, fichier->courante);
                }
        }
        return(0);
}
/**********************************************************************/
int function_deletechar(FICHIER *fichier, char *buffer, int pos)
{
        LIGNE *sauvcourante;

        /* le fichier a ete modifie */
        fichier->saved = 0;

        if ((fichier->courante->precedente != NULL) && (fichier->courante->suivante != NULL))
        {
                if (buffer[pos])
                {
                        strcpy(buffer + pos, buffer + pos + 1);
                        fichier->affiche_ligne(fichier->courante, fichier->ligne, buffer, fichier->premier_caractere);
                }
                else
                {
                        if ((fichier->courante->debut_marque == NOTMARKED) && (fichier->courante->suivante->debut_marque == NOTMARKED))
                        {
                                if (fichier->courante->suivante->suivante != NULL)
                                {
                                        strcpy(buffer + pos, fichier->courante->suivante->texte);
                                        realloue_texte(fichier->courante, buffer);
                                        sauvcourante = fichier->courante;
                                        fichier->courante = fichier->courante->suivante;
                                        destruction_ligne(fichier);
                                        fichier->courante = sauvcourante;
                                }
                                else
                                        beep();
                        }
                }
        }
        return(0);
}
/**********************************************************************/
int function_backspace(FICHIER *fichier, char *buffer, int pos)
{
        /* le fichier a ete modifie */
        fichier->saved = 0;

        if ((fichier->courante->precedente != NULL) && (fichier->courante->suivante != NULL))
        {
                if (fichier->colonne > XMIN)
                {
                        buffer[pos - 1] = '\0';
                        strcat(buffer, buffer + pos);
                        gauche(fichier, buffer, 1, 0);
                        affiche_ecran(fichier, fichier->premier_caractere, fichier->courante);
                }
                else
                {
                        if (*(buffer + fichier->premier_caractere))
                        {
                                strcpy(buffer + fichier->premier_caractere, buffer + fichier->premier_caractere + 1);
                                fichier->affiche_ligne(fichier->courante, fichier->ligne, buffer, fichier->premier_caractere);
                                affiche_ecran(fichier, fichier->premier_caractere, fichier->courante);
                        }
                        else
                                beep();
                }
        }
        return(0);
}
/**********************************************************************/
int function_uppercase(FICHIER *fichier, char *buffer, int pos)
{
        return(MAJUSCULE_BLOC);
}
/**********************************************************************/
int function_lowercase(FICHIER *fichier, char *buffer, int pos)
{
        return(MINUSCULE_BLOC);
}
/**********************************************************************/
int function_alignblock(FICHIER *fichier, char *buffer, int pos)
{
        return(ALIGNE_BLOC);
}
/**********************************************************************/
int function_wrapblock(FICHIER *fichier, char *buffer, int pos)
{
        return(WRAP_BLOC);
}
/**********************************************************************/
int function_recordmacro(FICHIER *fichier, char *buffer, int pos)
{
        char cmd[256];

        /* if no macro is defined or if a recording is completely done */
        if ((macro == NOMACRO) || (macro == RECORDED))
        {
                /* the 5 lines below are for debug purpose only */
                if (fmacro != NULL)
                {
                        fclose(fmacro);
                        erreur(message[MSG_MACRO_ALREADYOPENED], NULL);
                }

                /* on debute l'enregistrement */
                fmacro = fopen(MACROFILE, "w+b");
                if (fmacro != NULL)
                        macro = RECORDING;      /* macro recording can begin */
                else
                        macro = NOMACRO;        /* an error occured */
        }
        else if (macro == RECORDING)
        {
                /* si on arrete l'enregistrement */
                fclose(fmacro);
                fmacro = NULL;  /* just for security */

                reentrant = 1; /* evite d'etre reentrant */
                raz_zones(formmacro);
                if (lire_formulaire_simple(formmacro) == OKBUTTON)
                {
                        /* copie la macro par defaut sous son nouveau nom */
                        if (*vmacroname)
                        {
                                sprintf(cmd, "cp %s %s >/dev/null 2>/dev/null", MACROFILE, vmacroname);
                                system(cmd);
                        }
                }
                reentrant = 0; /* reautorise re-entrance */
                macro = RECORDED;       /* the macro recording is completely done */
        }
        return(0);
}
/**********************************************************************/
int function_playmacro(FICHIER *fichier, char *buffer, int pos)
{
        /* si enregistrement de la macro n'est pas terminee */
        if (macro == RECORDING)
        {
                if (fmacro != NULL) /* just for security */
                {
                        /* we stop the current macro recording */
                        fclose(fmacro);
                        fmacro = NULL;
                }
                macro = RECORDED;       /* the macro recording is done */
        }

        if ((macro == RECORDED) || (macro == NOMACRO))
        {
                /* on reouvre le fichier pour le lire */
                fmacro = fopen(MACROFILE, "r+b");
                if (fmacro != NULL)
                        macro = PLAYING;
                else
                        macro = NOMACRO;        /* erreur */
        }
        return(0);
}
/**********************************************************************/
int function_bg(FICHIER *fichier, char *buffer, int position)
{
        raise(SIGTSTP); /* put this program in the background */
        return(0);
}
/**********************************************************************/
