---
title: Upgrading from 2.x to 3.x
permalink: /docs/upgrading/2-to-3/
---

Upgrading from an older version of Jekyll? A few things have changed in Jekyll 3
that you'll want to know about.

Before we dive in, go ahead and fetch the latest version of Jekyll:

```sh
gem update jekyll
```

Since v3.2 Jekyll requires Ruby version >= 2.1
{: .note .warning }

<div class="note feature">
  <h5>Diving in</h5>
  <p>Want to get a new Jekyll site up and running quickly? Simply
   run <code>jekyll new SITENAME</code> to create a new folder with a bare bones
   Jekyll site.</p>
</div>

### site.collections has changed

In 2.x, your iterations over `site.collections` yielded an array with the collection
label and the collection object as the first and second items, respectively. In 3.x,
this complication has been removed and iterations now yield simply the collection object.
A simple conversion must be made in your templates:

- `collection[0]` becomes `collection.label`
- `collection[1]` becomes `collection`

When iterating over `site.collections`, ensure the above conversions are made.

For `site.collections.myCollection` in Jekyll 2, you now do:

```liquid
{% raw %}
{% assign myCollection = site.collections | where: "label", "myCollection" | first %}
{% endraw %}
```

This is a bit cumbersome at first, but is easier than a big `for` loop.

### Dropped dependencies

We dropped a number of dependencies the Core Team felt were optional. As such, in 3.0, they must be explicitly installed and included if you use any of the features. They are:

- jekyll-paginate – Jekyll's pagination solution from days past
- jekyll-coffeescript – processing of CoffeeScript
- jekyll-gist – the `gist` Liquid tag
- pygments.rb – the Pygments highlighter
- redcarpet – the Markdown processor
- toml – an alternative to YAML for configuration files
- classifier-reborn – for `site.related_posts`

### Future posts

A seeming feature regression in 2.x, the `--future` flag was automatically _enabled_.
The future flag allows post authors to give the post a date in the future and to have
it excluded from the build until the system time is equal or after the post time.
In Jekyll 3, this has been corrected. **Now, `--future` is disabled by default.**
This means you will need to include `--future` if you want your future-dated posts to
generate when running `jekyll build` or `jekyll serve`.

<div class="note info">
  <h5>Future Posts on GitHub Pages</h5>
  <p>
    An exception to the above rule are GitHub Pages sites, where the <code>--future</code> flag remains <em>enabled</em>
    by default to maintain historical consistency for those sites.
  </p>
</div>

### Layout metadata

Introducing: `layout`. In Jekyll 2 and below, any metadata in the layout was merged onto
the `page` variable in Liquid. This caused a lot of confusion in the way the data was
merged and some unexpected behaviour. In Jekyll 3, all layout data is accessible via `layout`
in Liquid. For example, if your layout has `class: my-layout` in its YAML front matter,
then the layout can access that via `{% raw %}{{ layout.class }}{% endraw %}`.

### Syntax highlighter changed

For the first time, the default syntax highlighter has changed for the
`highlight` tag and for backtick code blocks. Instead of [Pygments.rb](https://github.com/tmm1/pygments.rb),
it's now [Rouge](http://rouge.jneen.net/). If you were using the `highlight` tag with certain
options, such as `hl_lines`, they may not be available when using Rouge. To
go back to using Pygments, set `highlighter: pygments` in your
`_config.yml` file and run `gem install pygments.rb` or add
`gem 'pygments.rb'` to your project's `Gemfile`.

### Relative Permalink support removed

In Jekyll 3 and above, relative permalinks have been deprecated. If you
created your site using Jekyll 2 and below, you may receive the following
error when trying to **serve** or **build**:

```text
Since v3.0, permalinks for pages in subfolders must be relative to the site
source directory, not the parent directory. Check
https://jekyllrb.com/docs/upgrading/ for more info.
```

This can be fixed by removing the following line from your `_config.yml` file:

```yaml
relative_permalinks: true
```

### Permalinks no longer automatically add a trailing slash

In Jekyll 2, any URL constructed from the `permalink:` field had a trailing slash (`/`) added to it automatically.  Jekyll 3 no longer adds a trailing slash automatically to `permalink:` URLs. This can potentially result in old links to pages returning a 404 error. For example, suppose a page previously contained the YAML `permalink: /:year-:month-:day-:title` that resulted in the URL `example.com/2016-02-01-test/` (notice the trailing slash), Jekyll internally generates a folder named `2016-02-01-test`. In Jekyll 3, the same `permalink:` generate the file `2016-02-01-test.html` and the URL for the same page will be `example.com/2016-02-01-test`, and consequently any links to the old URL will result in a 404 error. In order to maintain the same URLs and avoid this problem, a trailing slash should be added to the `permalink:` field, for example `permalink: /:year-:month-:day-:title/`.

### All my posts are gone! Where'd they go!

Try adding `future: true` to your `_config.yml` file. Are they showing up now? If they are, then you were ensnared by an issue with the way Ruby parses times. Each of your posts is being read in a different timezone than you might expect and, when compared to the computer's current time, is "in the future." The fix for this is to add [a timezone offset](https://en.wikipedia.org/wiki/List_of_UTC_time_offsets) to each post (and make sure you remove `future: true` from your `_config.yml` file). If you're writing from California, for example, you would change this:

```yaml
---
date: 2016-02-06 19:32:10
---
```

to this (note the offset):

```yaml
---
date: 2016-02-06 19:32:10 -0800
---
```

### My categories have stopped working!

If you organized your categories as `/_posts/code/2008-12-24-closures.md`, you will need to restructure your directories to put the categories _above_ the `_posts` directories, as follows: `/code/_posts/2008-12-24-closures.md`.

_Did we miss something? Please click "Improve this page" above and add a section. Thanks!_
