/*
 * Copyright 2003, 2004  The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 */
package org.apache.ws.jaxme.xs.xml.impl;

import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.xml.*;
import org.xml.sax.SAXException;

/** <p>Implementation of <code>xs:numFacet</code>, following
 * this specification:
 * <pre>
 *  &lt;xs:complexType name="numFacet"&gt;
 *    &lt;xs:complexContent&gt;
 *      &lt;xs:restriction base="xs:facet"&gt;
 *        &lt;xs:sequence&gt;
 *          &lt;xs:element ref="xs:annotation" minOccurs="0"/&gt;
 *        &lt;/xs:sequence&gt;
 *        &lt;xs:attribute name="value" type="xs:nonNegativeInteger" use="required"/&gt;
 *      &lt;/xs:restriction&gt;
 *    &lt;/xs:complexContent&gt;
 *  &lt;/xs:complexType&gt;
 * </pre></p>
 *
 * @author <a href="mailto:joe@ispsoft.de">Jochen Wiedmann</a>
 */
public abstract class XsTNumFacetImpl extends XsTFixedFacetImpl
    implements XsTNumFacet {
  private long value = -1;

  protected XsTNumFacetImpl(XsObject pParent) {
    super(pParent);
  }

  public void setValue(long pValue) throws SAXException {
    if (pValue < 0) {
      throw new LocSAXException("The 'value' attribute must not be negative.", getLocator());
    }
    value = pValue;
  }

  public long getValue() {
    return value;
  }

  public void validate() throws SAXException {
    super.validate();
    if (value == -1) {
      throw new LocSAXException("Missing 'value' attribute.", getLocator());
    }
  }
}
