#ifndef _JACK_C
#define _JACK_C

#include <stdio.h>
#include <jack/jack.h>

#ifndef FAILURE
#define FAILURE exit(1)
#endif

jack_client_t *
xjack_client_new ( const char *name )
{
  jack_client_t *client = jack_client_new ( name ) ;
  if ( ! client ) {
    fprintf ( stderr , "jack_client_new() failed: %s\n" , name ) ;
    FAILURE ;
  }
  return client ;
}

int 
xjack_disconnect ( jack_client_t *client , const char *src , const char *dst )
{
  int err = jack_disconnect ( client , src , dst ) ;
  if ( err ) {
    fprintf ( stderr , "jack_disconnect() failed: '%s' -> '%s'\n" , src , dst ) ;
    FAILURE ;
  }
  return err ;
}

int 
xjack_connect ( jack_client_t *client , const char *src , const char *dst )
{
  int err = jack_connect ( client , src , dst ) ;
  if ( err ) {
    fprintf ( stderr , "jack_connect() failed: '%s' -> '%s'\n" , src , dst ) ;
    FAILURE ;
  }
  return err ;
}

/* TRUE iff the input port `l' is connected to the output port `r'. */

static int
jack_port_is_connected_p ( jack_client_t *j , const char *l , const char *r ) 
{
  const char **c = jack_port_get_all_connections ( j , jack_port_by_name ( j , l ) ) ;
  if ( c ) {
    int k ;
    for ( k = 0 ; c[k] ; k++ ) {
      if ( strcmp ( c[k] , r ) == 0 ) {
	free ( c ) ;
	return 1 ;
      }
    }
    free ( c ) ;
  }
  return 0 ;
}

/* Delete all connections at the port `l'. */

static void
jack_port_clear_all_connections ( jack_client_t *j , const char *l ) 
{
  const char **c = jack_port_get_all_connections ( j , jack_port_by_name ( j , l ) ) ;
  if ( c ) {
    int k ;
    for ( k = 0 ; c[k] ; k++ ) {
      xjack_disconnect ( j , l , c[k] ) ;
    }
    free ( c ) ;
  }
}

#endif
