/****************************************************************************
 *                             ListWidget.h
 *
 * Author: Matthew Ballance
 * Desc:   Data structure for the core of the list widget
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_LIST_WIDGET_H
#define INCLUDED_LIST_WIDGET_H
#include "WidgetCommon.h"
#include "CmdSwitcher.h"

/*****************************************************************
 * Defines
 *****************************************************************/
#define SET_FLAG(flg) redrawFlags |= (flg)
#define CLR_FLAG(flg) redrawFlags &= ~(flg)
#define IS_FLAG_SET(flg) (redrawFlags & (flg))


#define REDRAW_PENDING    0x00000001
#define SCROLL_X          0x00000002
#define SCROLL_Y          0x00000004
#define EXPOSE            0x00000008
#define BUTTON_1_DOWN     0x00000010
#define BUTTON_2_DOWN     0x00000020
#define BUTTON_3_DOWN     0x00000040
#define BUTTON_RELEASE    0x00000080
#define MOUSE_DRAG        0x00001000
#define APP_REQ_REDRAW    0x00002000
#define CONFIGURE         0x00004000
#define FORCE_REDRAW      0x00008000
#define CURSOR_CHANGE     0x00010000

#define DRAW_FLAGS     ( REDRAW_PENDING | SCROLL_X | SCROLL_Y | \
                         EXPOSE | APP_REQ_REDRAW | CONFIGURE | FORCE_REDRAW )
#define REPAINT_FLAGS  ( SCROLL_X | SCROLL_Y | APP_REQ_REDRAW | FORCE_REDRAW)
#define BUTTONS_DOWN   ( BUTTON_1_DOWN | BUTTON_2_DOWN | BUTTON_3_DOWN )

typedef enum {
    LWC_Config = 1,
    LWC_Cget,
    LWC_Redraw,
    LWC_NumCmds
} LW_Cmds;

static CmdSwitchStruct lw_cmds[] = {
    {"config",             LWC_Config    },
    {"configure",          LWC_Config    },
    {"cget",               LWC_Cget      },
    {"redraw",             LWC_Redraw    },
    {"",                   0             }
};

class ListTitle;
class SdbSignal;
class SdbReader;

class ListWidget {

    public:
        ListWidget(
                Tk_Window        tkwin,
                Tcl_Interp      *interp,
                int              argc,
                char           **argv);

        void EventProc(XEvent *eventPtr);
        int InstCmd(int argc, char **argv);

        void SetupRedraw(Uint32 flags);
        void DisplayWidget(void);

        Char        *instName;
        Uint32       okay;

    private:
        ListTitle          *listTitle;
        Tk_Window           tkwin;
        Display            *display;
        Tcl_Interp         *interp;

        Tk_3DBorder         background;
        Tk_Font             tkfont;

        Uint32              redrawFlags;


        Pixmap              backingPixmap;
        Uint32              backingPixmapWidth;
        Uint32              backingPixmapHeight;
        Uint32              backingPixmapValid;

        Pixmap              displayPixmap;
        Uint32              widgetWidth;
        Uint32              widgetHeight;

        Char               *sdbrName;
        SdbReader          *sdbr;

        enum {
            TC_TextColor     = 0,
            TC_NumColors
        };

        GC                  GCs[TC_NumColors];
        XColor             *colors[TC_NumColors];

        int Configure(int argc, char **argv, int flags);
        void UpdatePixmaps(void);
        void RepaintPixmap(Pixmap pixmap);

        enum {
            Opt_Background,
            Opt_Foreground,
            Opt_Font,
            Opt_Sdbr,
            Opt_NumOpts
        };

        /***********************************************************
         * getConfigSpec()
         ***********************************************************/
        Tk_ConfigSpec *getConfigSpec(void) {
            static Tk_ConfigSpec configSpec[] = {
               {TK_CONFIG_BORDER, "-background", "background", "Background",
                   "grey80", Tk_Offset(ListWidget, background), 
                   TK_CONFIG_COLOR_ONLY},
               {TK_CONFIG_COLOR, "-foreground", "foreground", "Foreground",
                   "black", Tk_Offset(ListWidget, colors[TC_TextColor]),
                   TK_CONFIG_COLOR_ONLY},
               {TK_CONFIG_FONT, "-font", "font", "Font", "Fixed 18", 
                   Tk_Offset(ListWidget, tkfont), 0},

               {TK_CONFIG_STRING, "-sdbr", "sdbr", "Sdbr", (char *)NULL,
                   Tk_Offset(ListWidget, sdbrName), 0},

               {TK_CONFIG_END, (char *)NULL, (char *)NULL, (char *)NULL, 
                   (char *)NULL, 0, 0}
            };
            return configSpec;
        }

        /***********************************************************
         * optionSpecified()
         ***********************************************************/
        Uint32 optionSpecified(Uint32 idx) {
            return (getConfigSpec()[idx].specFlags&TK_CONFIG_OPTION_SPECIFIED);
        }
};


#endif /* INCLUDED_LIST_WIDGET_H */
