/****************************************************************************
 *                            IviStaticPackages.cc
 *
 * Author: Matthew Ballance
 * Desc:   Implements the static package loading...
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include <tcl.h>
#include <string.h>
#include "config.h"

#ifndef ENABLE_SHARED_BUILD
extern "C" int tkhtml_Init(Tcl_Interp *interp);
extern "C" int Tkhtml_SafeInit(Tcl_Interp *interp);
extern "C" int ListTitle_Init(Tcl_Interp *interp);
extern "C" int List_widget_SafeInit(Tcl_Interp *interp);
extern "C" int Stub_dfio_Init(Tcl_Interp *interp);
extern "C" int Stub_dfio_SafeInit(Tcl_Interp *interp);
extern "C" int Tree_widget_Init(Tcl_Interp *interp);
extern "C" int Tree_widget_SafeInit(Tcl_Interp *interp);
extern "C" int Vcd_filter_Init(Tcl_Interp *interp);
extern "C" int Vcd_filter_SafeInit(Tcl_Interp *interp);
extern "C" int Wave_editor_Init(Tcl_Interp *interp);
extern "C" int Wave_editor_SafeInit(Tcl_Interp *interp);
extern "C" int Wave_widget_Init(Tcl_Interp *interp);
extern "C" int Wave_widget_SafeInit(Tcl_Interp *interp);
extern "C" int Vvp_remote_sim_Init(Tcl_Interp *interp);
extern "C" int Vvp_remote_sim_SafeInit(Tcl_Interp *interp);
extern "C" int Shm_dfio_Init(Tcl_Interp *interp);
extern "C" int Shm_dfio_SafeInit(Tcl_Interp *interp);
extern "C" int iviTktable_Init(Tcl_Interp *interp);
extern "C" int iviTktable_SafeInit(Tcl_Interp *interp);
#ifndef __MINGW32__
extern "C" int Ghdl_remote_sim_Init(Tcl_Interp *interp);
extern "C" int Ghdl_remote_sim_SafeInit(Tcl_Interp *interp);
extern "C" int Cver_remote_sim_Init(Tcl_Interp *interp);
extern "C" int Cver_remote_sim_SafeInit(Tcl_Interp *interp);
#endif

static struct IviStaticPkg {
    const char                 *libName;
    Tcl_PackageInitProc        *initProc;
    Tcl_PackageInitProc        *safeInitProc;
    bool                        loaded;
} prvIviStaticPkg[] = {
    { "tkhtml",    tkhtml_Init, Tkhtml_SafeInit, false },
    { "list_widget",    ListTitle_Init, List_widget_SafeInit, false },
    { "stub_dfio",      Stub_dfio_Init, Stub_dfio_SafeInit, false },
    { "tree_widget",    Tree_widget_Init, Tree_widget_SafeInit, false },
    { "vcd_filter",     Vcd_filter_Init,  Vcd_filter_SafeInit, false  },
    { "wave_widget",    Wave_widget_Init, Wave_widget_SafeInit, false },
    { "vvp_remote_sim", Vvp_remote_sim_Init, Vvp_remote_sim_SafeInit, false },
#ifndef __MINGW32__
    { "ghdl_remote_sim", Ghdl_remote_sim_Init, Ghdl_remote_sim_SafeInit,false},
    { "cver_sim",        Cver_remote_sim_Init, Cver_remote_sim_SafeInit,false},
#endif
    { "shm_dfio",       Shm_dfio_Init, Shm_dfio_SafeInit, false },
    { "iviTktable",     iviTktable_Init, iviTktable_SafeInit, false },
    { (const char *)0,  (Tcl_PackageInitProc *)0, (Tcl_PackageInitProc *)0 },
};

/*    { "wave_editor",    Wave_editor_Init, Wave_editor_SafeInit }, */

/********************************************************************
 * Ivi_LoadStaticCmd()
 ********************************************************************/
static int Ivi_LoadStaticCmd(
        ClientData        clientData,
        Tcl_Interp       *interp,
        int               argc, 
        const char      **argv)
{
    int i=0, ret = TCL_OK;

    while (prvIviStaticPkg[i].libName) {
        if (!strcmp(prvIviStaticPkg[i].libName, argv[1])) {
            if (!prvIviStaticPkg[i].loaded) {
                ret = prvIviStaticPkg[i].initProc(interp);
                prvIviStaticPkg[i].loaded = true;
 
                if (ret != TCL_OK) {
                    fprintf(stderr, "ERROR: Init of pkg \"%s\" failed: %s\n",
                        argv[1], Tcl_GetStringResult(interp));
                    fflush(stderr);
                }
            }
            break;
        }
        i++;
    }

    if (!prvIviStaticPkg[i].libName) {
        Tcl_AppendResult(interp, "couldn't locate pkg ", argv[1], 0);
        fprintf(stderr, "ERROR: Cannot find pkg \"%s\"\n", argv[1]);
        return TCL_ERROR;
    }

    return ret;
}

/********************************************************************
 * IviSTaticPkgs_Init()
 ********************************************************************/
extern "C" int IviStaticPkgs_Init(Tcl_Interp *interp)
{
#if 0
    int i=0;

    while (prvIviStaticPkg[i].libName) {
        fprintf(stderr, "Register StaticPackage \"%s\"\n", 
                prvIviStaticPkg[i].libName);
        Tcl_StaticPackage(interp, prvIviStaticPkg[i].libName,
                prvIviStaticPkg[i].initProc, prvIviStaticPkg[i].safeInitProc);
        i++;
    }

    return TCL_OK;
#endif
    Tcl_CreateCommand(interp, "ivi_load_pkg", 
            (Tcl_CmdProc *)Ivi_LoadStaticCmd, 0, 0);

    return TCL_OK;
}

/********************************************************************
 * IviStaticPkgs_Finish()
 ********************************************************************/
extern "C" int IviStaticPkgs_Finish(Tcl_Interp *interp)
{
    int i=0, ret;

    while (prvIviStaticPkg[i].libName) {
        if (!prvIviStaticPkg[i].loaded) {
            ret = prvIviStaticPkg[i].initProc(interp);

            if (ret != TCL_OK) {
                fprintf(stderr, "ERROR: Problem initializing pkg \"%s\": %s\n",
                    prvIviStaticPkg[i].libName, Tcl_GetStringResult(interp));
            }
        }
        prvIviStaticPkg[i].loaded = true;
        i++;
    }
}

#endif /* ENABLE_SHARED_BUILD */

