/****************************************************************************
 *                        IviRemoteDesignDBSrv.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a DDB reflector. This end intercepts commands to the
 *         DDB in the IVI process and sends the commands to the VVP DDB
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_IVI_REMOTE_DESIGN_DB_SRV_H
#define INCLUDED_IVI_REMOTE_DESIGN_DB_SRV_H
#include "DesignDB.h"
#include "RemoteAppTclCmdListener.h"

class IviRemoteDesignDBSrv : public DesignDB {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * IviRemoteDesignDBSrv()
         ************************************************************/
        IviRemoteDesignDBSrv(
                RemoteAppTclCmdListener      *cmdChan,
                Tcl_Interp                   *interp,
                int                           argc,
                char                        **argv);

        /************************************************************
         * InstCmd()
         ************************************************************/
        virtual int InstCmd(int argc, char **argv);

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        RemoteAppTclCmdListener         *d_cmdChan;
        Tcl_Interp                      *d_interp;

};


#endif /* INCLUDED_IVI_REMOTE_DESIGN_DB_SRV_H */
