/****************************************************************************
 *                          CverRemoteSimPlugin.h
 *
 * Author: Matthew Ballance
 * Desc:
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_CVER_REMOTE_SIM_PLUGIN_H
#define INCLUDED_CVER_REMOTE_SIM_PLUGIN_H
#include "IviRemoteSimPlugin.h"

class CverRemoteIviSim;
class CverRemoteSimPlugin : public IviRemoteSimPlugin {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * CverRemoteSimPlugin()
         */
        /**
         ************************************************************/
        CverRemoteSimPlugin(Tcl_Interp *interp);

        /************************************************************
         * ~CverRemoteSimPlugin()
         */
        /**
         ************************************************************/
        virtual ~CverRemoteSimPlugin();

        /************************************************************
         * BeginRun()
         ************************************************************/
        virtual int BeginRun(Uint32 runLen);

        /************************************************************
         * HandleDisconnect()
         ************************************************************/
        virtual void HandleDisconnect();

    /****************************************************************
     * Protected Methods
     ****************************************************************/
    protected:

        /************************************************************
         * ConstructSim()
         */
        /** Expected to construct an IviSim object of the type 
         *  used by the remote portion of this simulator
         ************************************************************/
        virtual IviSim *ConstructSim();

        /************************************************************
         * ConstructDDB()
         */
        /**
         ************************************************************/
        virtual DesignDB *ConstructDDB();

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * TimeCB
         */
        /** 
         ************************************************************/
        static int TimeCB(p_cb_data cb_data) { 
            ((CverRemoteSimPlugin *)cb_data->user_data)->TimeCB();
            return 0;
        }
        void TimeCB();

        /************************************************************
         * EndOfSimCB
         */
        /**
         * Called when simulation ends
         ************************************************************/
        static int EndOfSimCB(p_cb_data cb_data) {
            ((CverRemoteSimPlugin *)cb_data->user_data)->EndOfSimCB();
            return 0;
        }
        void EndOfSimCB();

        /************************************************************
         * EndOfCompileCB()
         */
        /** 
         ************************************************************/
        static int EndOfCompileCB(p_cb_data cb_data) {
            ((CverRemoteSimPlugin *)cb_data->user_data)->EndOfCompileCB();
            return 0;
        }
        void EndOfCompileCB();

        /************************************************************
         * SetupVpiCBs()
         */
        /** 
         ************************************************************/
        void SetupVpiCBs();

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:

        CverRemoteIviSim           *d_sim;
};

#endif /* INCLUDED_CVER_REMOTE_SIM_PLUGIN_H */
