/****************************************************************************
 *                                types.h
 *
 * Author: Matthew Ballance
 * Desc:   Defines the core data-types for the IVI project. 
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_TYPES_H
#define INCLUDED_TYPES_H
#include <new>

typedef unsigned int       Uint32;
typedef int                Int32;

typedef char               Char;
typedef unsigned char      Uchar;
typedef unsigned char      UChar;
typedef unsigned char      Uint8;
typedef char               Int8;

typedef unsigned short int Uint16;
typedef short int          Int16;

typedef unsigned char      boolean;
typedef void              *voidPtr;
typedef double             Double;

typedef struct {
   Uint32        low;
   Uint32        high;
} Uint64;
#if 0
#ifndef __cplusplus
#else
#include "uint64.h"
#endif
#endif

#ifndef __cplusplus
typedef enum {
   false  = 0,
   true   = 1
 } booleantype;
#endif
typedef void (*voidFuncPtr)(void *);

#ifndef NULL
#define NULL 0
#endif


#endif
