#*****************************************************************************
#*                              popup.tcl
#*
#* Author: Matthew Ballance
#* Desc:   Implements a popup-menu wrapper...
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#*****************************************************************************

namespace eval Popup {
    namespace export Popup bind
}

#********************************************************************
#* Popup
#********************************************************************
proc Popup::Popup {path args} {
    array set $path {_dummy other}
    upvar #0 $path data

    set data(popup_x) 0
    set data(popup_y) 0

    set menu [menu $path -tearoff 0]

    rename $path ::$path:cmd
    proc ::$path {cmd args} "return \[eval Popup::cmd $path \$cmd \$args\]"

    return $path
}

#********************************************************************
#* popup
#********************************************************************
proc Popup::popup {path W x y} {
    upvar #0 $path data

    set gx [winfo rootx $W]
    set mx [expr $x + $gx]
    set gy [winfo rooty $W]
    set my [expr $y + $gy]

    set data(popup_x) $x
    set data(popup_y) $y

    tk_popup $path $mx $my
}

#********************************************************************
#* cmd
#********************************************************************
proc Popup::cmd {path cmd args} {
    upvar #0 $path data

    if {$cmd == "bind"} {
        set w [lindex $args 0]
        set tag [lindex $args 1]
        bind $w $tag "Popup::popup $path %W %x %y ; break"
    } elseif {$cmd == "x"} {
        return $data(popup_x)
    } elseif {$cmd == "y"} {
        return $data(popup_y)
    } else {
        eval ::$path:cmd $cmd $args
    }
}




