/****************************************************************************
 *                               ivi_dlfcn.h
 *
 * Author: Matthew Ballance
 * Desc:   Compat header for dll-loading functions... Borrowed from IVL...
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_IVI_DLFCN_H
#define INCLUDED_IVI_DLFCN_H

typedef void    *ivi_dll_t;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

ivi_dll_t ivi_dlopen(const char *name);
void *ivi_dlsym(ivi_dll_t dll, const char *nm);
void ivi_dlclose(ivi_dll_t dll);
const char *ivi_dlerror(void);

#ifdef __cplusplus
};
#endif /* __cplusplus */

#endif /* INCLUDED_IVI_DLFCN_H */

