/****************************************************************************
 *                    RemoteAppConnectionListener.cc
 *
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "RemoteAppConnectionListener.h"
#include "RemoteAppConnection.h"


/********************************************************************
 * RemoteAppConnectionListener()
 ********************************************************************/
RemoteAppConnectionListener::RemoteAppConnectionListener(Uint32 subChanIdx)
{
    d_subChanIdx = subChanIdx;
    d_connection = 0;
}

/********************************************************************
 * ~RemoteAppConnectionListener()
 ********************************************************************/
RemoteAppConnectionListener::~RemoteAppConnectionListener()
{
    if (d_connection) {
        d_connection->DeleteListener(this);
    }
}

/********************************************************************
 * Connect()
 ********************************************************************/
void RemoteAppConnectionListener::Connect(RemoteAppConnection *connection)
{
    d_connection = connection;
}

/********************************************************************
 * Receive()
 ********************************************************************/
void RemoteAppConnectionListener::Receive(Uint32 idx, Uint32 len, Uchar *data)
{
    ;
}

/********************************************************************
 * Send()
 ********************************************************************/
int RemoteAppConnectionListener::Send(Uint32 idx, Uint32 len, Uchar *data)
{
    if (d_connection) {
        d_connection->Send(idx, len, data);
    } else {
        fprintf(stderr, "ERROR: Internal RemoteAppConnectionListener "
                "- NULL d_connection\n");
    }
}

