/****************************************************************************
 *                               PsGC.h
 * 
 * Author: Matthew Ballance
 * Desc:   Implements the device-specific GC for a Postscript device.
 *         NOTE: The PsGC is only used by PsPixmapObj.
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_PS_GC_H
#define INCLUDED_PS_GC_H
#include "types.h"
#include <stdarg.h>
#include <tcl.h>

class FileAccObj;
class GCObj;
class PsGC {
    public:

        /************************************************************
         * PsGC()
         ************************************************************/
        PsGC(GCObj *gc_templ);

        /************************************************************
         * SetGC()
         ************************************************************/
        void SetGC(FileAccObj *f);

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * emit()
         ************************************************************/
        void emit(FileAccObj *f, const char *fmt, ...);

    private:
        GCObj        *d_gcObj;
        Uint32        d_dpi;
        Tcl_DString   d_dStr;

        static char   d_buf[8192];
};

#endif /* INCLUDED_PS_GC_H */

