/****************************************************************************
 *                              MenuMgr.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a menu manager. Creates menus from a description
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_MENU_MGR_H
#define INCLUDED_MENU_MGR_H
#include <tcl.h>
#include "types.h"
#include "ivi_String.h"
#include "Stack.h"
#include "TclListObj.h"
#include "LogInstance.h"
#include "FileAccObj.h"


class Tokenizer;
class MenuCmd;
class MenuDesc;
class PackList;
class MenuMgr {

    public:
        MenuMgr(Tcl_Interp *interp, Char *interName);
        int InstCmd(int argc, Tcl_Obj *const objv[]);
        int LoadFileHelper(int objc, Tcl_Obj *const objv[]);

        Char *getName(void); 

    private:
        String              instName;
        Tcl_Interp         *interp;
        Uint32              loadMode;
        Uint32              createMode;
        Uint32              menuBarMode;
        Uint32              d_toplevItemType;
        Tcl_HashTable       hashTable;
        Tcl_HashTable       d_varTable;
        String              pathTmp;
        Uint32              d_bboxCnt;
        String              dlgPath;
        String              groupTmp;
        String              d_parseBuf;
        String              d_currBB;
        TclListObj          packList;
        Stack<Tcl_Obj>      infoStack;

        LogInstance        *log;
        LogInstLevel        log_low;
        LogInstLevel        log_med;
        LogInstLevel        log_high;

#define TRANS_2LABEL    0x00000001
#define OPT_TEXT        0x00000001

        int ProcessOptions(
                TclListObj        &cmd_list,
                MenuDesc          *menu,
                Uint32             itemType,
                Uint32             in_flags);

        int RealizeScriptItem(String &pathTmp, MenuDesc *menu);

        int ProcessLabel(
                Tcl_Interp        *interp,
                TclListObj        &cmd_list,
                Tcl_Obj           *string);

        int ProcessLabel(
                Tcl_Interp        *interp,
                TclListObj        &cmd_list,
                Char              *string);

        int ProcessLoad(
                int    objc,
                Tcl_Obj *const objv[]);

        int RealizeMenu(MenuDesc *menu);

        Tcl_Obj *FindList(char *path);
        MenuDesc *FindNode(char *nodename);
        char *RemoveAmp(char *buf, char *str);

        char *Identify(char *str);
        char *Identify(Tcl_Obj *id) { return Identify(Tcl_GetString(id)); }

        MenuCmd    *currCmd;
        char        d_varBuf[4096];

        MenuDesc *ParseSpec(Tokenizer &t);
        MenuDesc *ParseMenuFile(char *filename);

        int AppendCmd(int objc, Tcl_Obj *const objv[]);
        void GlobObjv(String &buf, int objc, Tcl_Obj *const objv[]);

        char *expand_string(Tcl_Interp *interp_p, char *str);

};

#endif /* INCLUDED_MENU_MGR_H */
