/****************************************************************************
 *                              DialogMgr.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a dialog-box manager. Creates dialog boxes from a
 *         description
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_DIALOG_MGR_H
#define INCLUDED_DIALOG_MGR_H
#include <tcl.h>
#include "types.h"
#include "ivi_String.h"
#include "Stack.h"
#include "TclListObj.h"


class PackList;
class DialogMgr {

    public:
        DialogMgr(Tcl_Interp *interp, Char *interName);
        int InstCmd(int argc, Tcl_Obj *const objv[]);
        int LoadFileHelper(int objc, Tcl_Obj *const objv[]);

        Char *getName(void); 

    private:
        String              instName;
        Tcl_Interp         *interp;
        Tcl_Interp         *slaveInterp;
        Uint32              loadMode;
        Uint32              createMode;
        Tcl_HashTable       hashTable;
        String              pathTmp;
        String              dlgPath;
        String              groupTmp;
        Stack<PackList>    *packStack;
        PackList           *currPackList;
        TclListObj          widgetList;

#define OPT_TEXT        0x00000001
#define OPT_VERT        0x00000002
#define OPT_HORIZ       0x00000004

        int ProcessOpts(
                Tcl_Interp      *interp,
                Tcl_Obj         *id, 
                TclListObj      &cmd_list,
                Uint32           in_spec,
                Uint32           objc,
                Tcl_Obj  *const objv[],
                Uint32 valid_vect, Uint32 *spec_vect);
};

#endif /* INCLUDED_DIALOG_MGR_H */
