//------------------------------------------------------------------------------
// Project:     vendor_lib: IVI example showing use of vendor-specific libs
// File:        myFDCE.v
// Description: Xilinx-style DFF w/ async clear and clock enable
// History:     2003iv17, FB, created.
//------------------------------------------------------------------------------

`timescale 1us / 1ns

module myFDCE (Q, C, CE, CLR, D);
    input  C, CE, CLR, D;
    output Q;
    reg    Q;

	always @(posedge CLR)
		assign Q = 0;

	always @(posedge C)
	    if (CE)
			Q <= D;

endmodule

//------------------------------------------------------------------------------
// end of file
