#****************************************************************************
#*                            common.mk
#*
#* Author: Matthew Ballance
#* Desc:   Bootstrap include file. This file contains stuff that must be
#*         present during configuration. It cannot wait until after the 
#*         .in's have been pre-processed.
#****************************************************************************

#*****************************************************************
#* Setup install directories
#*****************************************************************
tcldir       = $(prefix)/lib/ivi/tcl
ivilibdir    = $(prefix)/lib/ivi/lib
ivimoddir    = modules
ivisharedir  = $(prefix)/share/ivi
iviexdir     = $(prefix)/examples
ividocdir    = $(prefix)/doc
etcdir       = $(prefix)/etc

instdir_list = tcldir ivilibdir ivimoddir ivisharedir iviexdir ividocdir etcdir

#*****************************************************************
#* TCL-script rules
#*****************************************************************
ivi_% : $(srcdir)/%
	rm -f ivi_$*
	ln -s $(srcdir)/$* ivi_$*

pkgIndex.tcl : 
	$(top_builddir)/src/scripts/mk_pkg_index$(EXEEXT) $(PKG_IDX_FLAGS) \
	    $^ > pkgIndex.tcl

#*****************************************************************
#* TexInfo rules
#*****************************************************************

%.html %_toc.html : $(srcdir)/%.texi
	$(top_srcdir)/texi2html -I $(srcdir) -split_node -number $(srcdir)/$*.texi


#*****************************************************************
#* Shared library rules
#*****************************************************************
%.$(SLIB_EXT) : $(%_DEPEND)
	$(CXX) -shared -o $@ $($(*)_DEPEND)

#*****************************************************************
#* Standard targets
#*****************************************************************


.PHONY: subdirs clean local-clean local-install dist local-dist

subdirs: deps 
	@list='$(SUBDIRS)'; for dir in $$list; do \
	      $(MAKE) -C "$$dir" || $(DIE) ; \
        done;

clean: local-clean
	@list='$(SUBDIRS)'; for dir in $$list; do \
            $(MAKE) -C "$$dir" clean ; \
            done;

#********************************************************************
#* dist
#********************************************************************
include $(top_builddir)/confs/common_bld.mk

CORE_DIST_FILES=Makefile Makefile.in 

WHOLE_DIST_FILES=Makefile.in $(DIST_FILES)


dist: local-dist
	@list='$(SUBDIRS)'; for dir in $$list; do \
	    if test $(MAKELEVEL) = 0; then \
                mkdir -p $(top_builddir)/$(DISTNAME) ; \
                destdir="$$dir" ;  \
            else \
                destdir="$(destdir)/$$dir" ; \
            fi ; \
            $(MAKE) -C "$$dir" destdir=$$destdir dist || $(DIE) ; \
            done;
	@if test $(MAKELEVEL) = 0; then \
            cd $(top_builddir) ; \
            rm -f $(DISTNAME).tar $(DISTNAME).tar.gz ; \
            $(TAR) -cf $(DISTNAME).tar $(DISTNAME) ; \
            $(GZIP) $(DISTNAME).tar ; \
            rm -rf $(DISTNAME) ; \
         fi

local-dist:
	@if test $(MAKELEVEL) = 0; then \
            rm -rf $(top_builddir)/$(DISTNAME) ; \
         fi
	@file_list="" ; \
	list='$(WHOLE_DIST_FILES)'; for file in $$list; do \
	      file_list="$$file_list $(srcdir)/$$file" ; \
        done; \
        if test "x$$file_list" != "x"; then \
            mkdir -p $(top_builddir)/$(DISTNAME)/$(destdir) ; \
            cp $$file_list $(top_builddir)/$(DISTNAME)/$(destdir) ; \
        fi

#********************************************************************
#* Install Targets
#********************************************************************
.PHONY:  install local-install $(PROG_INST_TARGETS) $(DATA_INST_TARGETS)

install : local-install
	@list='$(SUBDIRS)'; for dir in $$list; do \
            $(MAKE) -C "$$dir" install || $(DIE) ; \
         done;

local-install: $(INSTALL_TARGETS) 

DIE=exit 1


%.o : $(srcdir)/%.cc
	$(CXX) $(CXXFLAGS) $(srcdir)/$*.cc -c 

%.o : $(srcdir)/%.c
	$(CC) $(CFLAGS) $(srcdir)/$*.c -c 

#********************************************************************
#* SLIB_CMD
#********************************************************************
define SLIB_CMD
   $(CXX) $(SLIB_FLAGS) $^ -o $@
endef

#********************************************************************
#* EXEC_CMD
#********************************************************************
define EXEC_CMD
   $(CXX) $^ -o $@
endef

#********************************************************************
#* AR_CMD
#********************************************************************
define AR_CMD
    rm -f $@
    $(AR) vcq $@ $^
    $(RANLIB) $@
endef

#********************************************************************
#* cc_deps
#********************************************************************
cc_deps : $(foreach file,$(CC_DEPS_FILES), $(srcdir)/$(file))
	@if test "x$(CC_DEPS_FILES)" != "x" ; then \
            echo "Making Dependencies" \
            $(CXX) -MM $(CXXFLAGS) $^ > cc_deps ; \
        fi

#********************************************************************
#* INSTALL_DATA_CMD
#********************************************************************
define INSTALL_DATA_CMD
    @fl='$(^)'; for f in $$fl; do 
        echo "Installing $$f" 
        $(INSTALL_DATA)  $(srcdir)/$$f $(prefix)
endef

ifeq ($(wildcard cc_deps), cc_deps)
   include cc_deps
endif

Makefile : $(srcdir)/Makefile.in
	(cd $(top_builddir) ; ./config.status)
	$(MAKE) -f Makefile
	exit 0

deps : Makefile cc_deps


