/*
 * italc.h - declaration of class italc which is the widget for the main window of iTALC
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _ITALC_H
#define _ITALC_H

#include <qmainwindow.h>
#include <qwhatsthis.h>
#include <qthread.h>

#include "client.h"

/*!
  \brief The italc-class

  The italc-class provides the main-window for iTALC, menus and toolbars for interacting with user. 
  This class doesn't contain any relevant data, it just provides the GUI.

  \sa   clientManager and client for detailed description of internal functionality and data-structures.
*/


class QWorkspace;
class QToolBar;
class QPopupMenu;
class QSplitter;
#if QT_VERSION >= 0x030200
class QSplashScreen;
#endif

class italcSideBar;
class overviewWidget;
class clientManager;
class userList;
class chatManagement;
class screenshotList;
class configWidget;
class helpWidget;


extern QString MASTER_HOST;




class italc : public QMainWindow, public QThread
{
	Q_OBJECT
public:
	static italc * inst( void )
	{
		if( s_instOfMe == NULL )
			return( s_instOfMe = new italc );
		return( s_instOfMe );
	}

	QWorkspace * workspace( void )
	{
		return( m_workspace );
	}
	static bool ensureConfigPathExists( void );


private slots:
	// slots for actions in help-menu
	inline void enterWhatsThisMode( void )
	{
		QWhatsThis::enterWhatsThisMode();
	}
	void aboutITALC( void );


private:
	italc();
	// only for hiding copy-constructor, because italc is a singleton-class
	italc( const italc & ) :
		QMainWindow(),
		QThread()
	{
	}
	~italc();

	virtual void run( void );
	virtual void closeEvent( QCloseEvent * _ce );


	QWorkspace * m_workspace;

	QPopupMenu * m_filePopupMenu;
	QPopupMenu * m_actionsPopupMenu;
	QPopupMenu * m_helpPopupMenu;

	QToolBar * m_actionToolBar;
	QToolBar * m_viewToolBar;
	QSplitter * m_splitter;

	QWidget * m_sideBarWidget;
	italcSideBar * m_sideBar;
	int m_openedTabInSideBar;

	overviewWidget * m_overviewWidget;
	chatManagement * m_chatManagement;
	userList * m_userList;
	screenshotList * m_screenshotList;
	configWidget * m_configWidget;
	helpWidget * m_helpWidget;

	static italc * s_instOfMe;

	friend class clientManager;

} ;


#if QT_VERSION >= 0x030200
extern QSplashScreen * splashScreen;
#endif


#endif
