#ifndef __NETWORK_NONBLOCK_H
#define __NETWORK_NONBLOCK_H

typedef void (*NET_CALLBACK) (gint, gpointer);

void network_nonblock_init(void);
void network_nonblock_deinit(void);

/* nonblocking gethostbyname(), ip (gulong) is written to pipe when found
   PID of the resolver child is returned */
gint net_gethostname_nonblock(gchar *addr, gint pipe);

/* Connect to server, call func when finished */
gboolean net_connect_nonblock(gchar *server, gint port, IPADDR *my_ip, NET_CALLBACK func, gpointer data);
/* Kill the resolver child */
void net_disconnect_nonblock(gulong pid);


#endif
