/*
 gui-server.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

static gboolean signal_server_looking(SERVER_REC *server)
{
    g_return_val_if_fail(server != NULL, FALSE);

    server->gui_data = g_new0(SERVER_REC, 1);
    return TRUE;
}

static gboolean signal_server_disconnected(SERVER_REC *server)
{
    g_return_val_if_fail(server != NULL, FALSE);

    g_list_free(SERVER_GUI(server)->gone_nicks);
    SERVER_GUI(server)->gone_nicks = NULL;

    g_free(server->gui_data);
    server->gui_data = NULL;
    return TRUE;
}

void gui_server_init(void)
{
    signal_add_first("server looking", (SIGNAL_FUNC) signal_server_looking);
    signal_add("server connect failed", (SIGNAL_FUNC) signal_server_disconnected);
    signal_add("server disconnected", (SIGNAL_FUNC) signal_server_disconnected);
}

void gui_server_deinit(void)
{
    signal_remove("server looking", (SIGNAL_FUNC) signal_server_looking);
    signal_remove("server connect failed", (SIGNAL_FUNC) signal_server_disconnected);
    signal_remove("server disconnected", (SIGNAL_FUNC) signal_server_disconnected);
}
