#ifndef __GUI_MAINWINDOWS_H
#define __GUI_MAINWINDOWS_H

typedef struct
{
    GtkWidget *window;
    GtkWidget *entry;
    GtkWidget *servermenu;
    GList *specials; /* list of position in entry widget where are "special"
                        characters - bolds, underlines, colors, etc. */

    GtkWidget *cancel; /* cancel button */
    GtkWidget *statusbar;
    GList *statusbar_texts; /* text stack */
    gint statusbar_id; /* counter */

    gint main_id; /* toplevel id */
    gint nicklist_id; /* realname when mouse over nick in nicklist.. */

    GtkWidget *notebook; /* more than one subwindow, use notebook */
    GtkWidget *container;

    GtkWidget *usermodes[4]; /* away, invisible, wallops, server notes menu items */
    GtkWidget *autoraise; /* autoraise menu item */
    gchar *extramenu; /* window specific extra menu name */

    guint destroying:1;

    GList *children;
    WINDOW_REC *active;
}
MAIN_WINDOW_REC;

extern GList *mainwindows;

void gui_mainwindows_init(void);
void gui_mainwindows_deinit(void);

MAIN_WINDOW_REC *gui_mainwindow_create(WINDOW_REC *child);
void gui_mainwindow_destroy(MAIN_WINDOW_REC *window);

#endif
