/*
 gui-events-invite.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

static void sig_join(GtkWidget *dialog)
{
    SERVER_REC *server;
    gchar *channel;

    g_return_if_fail(dialog != NULL);

    server = gtk_object_get_data(GTK_OBJECT(dialog), "server");
    channel = gtk_object_get_data(GTK_OBJECT(dialog), "channel");

    signal_emit("command join", 3, channel, server, cur_channel);

    gtk_widget_destroy(dialog);
}

static gboolean event_invite(gchar *data, SERVER_REC *server, gchar *nick)
{
    gchar *params, *channel, *str;
    GtkWidget *dialog, *label;

    g_return_val_if_fail(data != NULL, FALSE);

    params = event_get_params(data, 2, NULL, &channel);
    if (*channel == '\0')
    {
        g_free(params);
        return TRUE;
    }

    channel = g_strdup(channel);

    dialog = gnome_dialog_new(PACKAGE, _("Join"), GNOME_STOCK_BUTTON_CLOSE, NULL);
    gtk_signal_connect_object(GTK_OBJECT(dialog), "destroy",
                              GTK_SIGNAL_FUNC(g_free), (GtkObject *) channel);
    gtk_signal_connect_object(GTK_OBJECT(dialog), "delete_event",
                              GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));
    gui_widget_depends_data(dialog, "server disconnected", server);

    gnome_dialog_button_connect_object(GNOME_DIALOG(dialog), 0, GTK_SIGNAL_FUNC(sig_join), GTK_OBJECT(dialog));
    gnome_dialog_button_connect_object(GNOME_DIALOG(dialog), 1, GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));

    gtk_object_set_data(GTK_OBJECT(dialog), "server", server);
    gtk_object_set_data(GTK_OBJECT(dialog), "channel", channel);

    str = g_strdup_printf(_("%s invites you to %s"), nick, channel);
    label = gtk_label_new(str); g_free(str);
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), label, TRUE, TRUE, 5);

    gtk_widget_show_all(dialog);

    g_free(params);
    return TRUE;
}

void gui_event_invite_init(void)
{
    signal_add("event invite", (SIGNAL_FUNC) event_invite);
}

void gui_event_invite_deinit(void)
{
    signal_remove("event invite", (SIGNAL_FUNC) event_invite);
}
