/*************************************************************************
 * 
 * irmp3 - Multimedia Audio Jukebox for Linux
 * http://irmp3.sourceforge.net
 *
 * $Source: /cvsroot/irmp3/irmp3/src/irmp3d/mod_magic.c,v $
 * $Id: mod_magic.c,v 1.5 2004/02/17 20:40:36 boucman Exp $
 *
 * Copyright (C) by Jeremy Rosen
 *
 * Please contact the current maintainer, Jeremy Rosen <jeremy.rosen@enst-bretagne.fr>
 * for information and support regarding irmp3.
 *
 *
 */

/*
 * This module will use libmagic to detect file types.
 * libmagic is the file recognition library used by the "file" command
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <magic.h>
#include <sys/stat.h>
#include <string.h>

#include "config.h"
#include "irmp3log.h"
#include "irmp3mod.h"
#include "mod_magic.h"

/*************************************************************************
 * GLOBALS     
 */
magic_t  mod_magic_cookie;


/*************************************************************************
 * MODULE INFO
 *	This structure is used to pass to mod_register to register
 *	our module with the main program.
 */
mod_t mod_magic = {
	"mod_magic",
	mod_magic_deinit,	// our deinit function
	NULL,			// called when got SIGHUP
	NULL,			// we aren't looking at any file
	NULL,			// no fdset to watch
	NULL,			// we don't need to be called periodically
	mod_magic_message,	// our message handler
	NULL,			// SIGCHLD handler
	mod_magic_init,
	NULL,			// avoid warning
};



/*************************************************************************
 * RECEIVE MESSAGE
 */
void mod_magic_message (int msgtype, char *msg,const char __attribute__((unused))*sender)
{
	struct stat st;
	char *c1,*c2;
	const char *desc_str;
		

	if (msgtype == MSGTYPE_QUERY) {
		c1 = strtok(msg," \t");
		c2 = strtok(NULL,"");
		if(!strcasecmp(c1,"songtype")) {
			if( stat(c2,&st) < 0) return; // it's not a file
			desc_str = magic_file(mod_magic_cookie,c2);
			if (!desc_str) return;
			if(!strncasecmp(desc_str,"MP3",3)) {
				mod_sendmsgf(MSGTYPE_INFO,"knowntype mp3 %s",c2);
			} else if (!strncasecmp(desc_str,"MP2",3)) {
				mod_sendmsgf(MSGTYPE_INFO,"knowntype mp2 %s",c2);
			} else if (!strncasecmp(desc_str,"MPEG",4)) {
				mod_sendmsgf(MSGTYPE_INFO,"knowntype mpg %s",c2);
			} else if (!strncasecmp(desc_str,"Standard MIDI",13)) {
				mod_sendmsgf(MSGTYPE_INFO,"knowntype midi %s",c2);
			} else if (!strncasecmp(desc_str,"Ogg data,",9)) {
				mod_sendmsgf(MSGTYPE_INFO,"knowntype ogg %s",c2);
			} else if (!strncasecmp(desc_str,"FLAC audio stream data",22)) {
				mod_sendmsgf(MSGTYPE_INFO,"knowntype flac %s",c2);
			} else {
				log_printf(LOG_ERROR,"you are using an unknown file type\n");
				log_printf(LOG_ERROR,"please report the next line to the irmp3 mailing list\n");
				log_printf(LOG_ERROR,"%s\n",desc_str);
			}
		}
	}
}


/*************************************************************************
 * MODULE INIT FUNCTION
 *	This is called rigth after starting IRMP3 and should set up global
 *	variables and register your module via mod_register().
 *	It should return NULL if everything went ok, or an error string
 *	with the error description.
 */
char *mod_magic_init (void)
{
	log_printf(LOG_DEBUG, "mod_magic_init(): initializing\n");

	// register our module with the main program so that it knows
	// what we want to handle. We must provide a pointer to a
	// mod_t variable which is valid during the whole runtime, so
	// don't specify a local variable here.
	mod_magic_cookie = magic_open(MAGIC_SYMLINK );
	magic_load(mod_magic_cookie,NULL);
	return NULL;
}


/*************************************************************************
 * MODULE DEINIT FUNCTION
 *	This is called right before IRMP3 shuts down. You should clean
 *	up all your used data here to prepare for a clean exit.
 */
void mod_magic_deinit (void)
{
	// nothing to do here

	log_printf(LOG_DEBUG, "mod_debug_deinit(): deinitialized\n");
	magic_close(mod_magic_cookie);
}




/*************************************************************************
 * EOF
 */
