<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("post-only");
commonHeader(_("Tracking") . " - ". _("Preview"));
/* Start error checking */

if ($uname == "") {
	$error = 1;
	__("The following error occured with your request for help: You did not enter a name.");
	PRINT "<br>";
	}
if ($uemail == "") {
	$error = 1;
	__("The following error occured with your request for help: You did not enter an e-mail address.");
	PRINT "<br>";
	}
if ($ID < 0) {
	$error = 1;
	__("A very unusual error occured.  Contact your sysadmin.");
	PRINT "<br>";
	}
if ($contents == "") {
	$error = 1;
	__("The following error occured with your request for help:  You did not enter any problem description.");
	PRINT "<br>";

	}

/* End error checking */

$contents = htmlspecialchars($contents);
$contents = stripslashes($contents);

if (@$error != 1)
{
	__("Please check that the job you are about to submit is correct.  If it is not, use the provided links to edit it.");
}
else
{
	PRINT "<br><b>\n";
	__("Errors occured with your request for help.  Your only option is to edit the job.");
	PRINT "</b><br>\n";
}
?>
<hr noshade>

<?php
if($emailupdates == "")
{
	$emailupdates = "no";
}

$DB = Config::Database();
$qID = $DB->getTextValue($ID);
if($is_group == "no")
{
	$query = "SELECT name FROM computers WHERE (ID = $qID)";
}
else
{
	$query = "SELECT name FROM groups WHERE (ID = $qID)";
}
$computername = $DB->getOne($query);
?>

<form method=post action="<?php echo Config::AbsLoc('users/helper-add.php'); ?>">
<input type=hidden name=status value=new>
<input type=hidden name=uname value="<?php echo $uname ?>">  
<input type=hidden name=uemail size=19 value="<?php echo $uemail ?>">
<input type=hidden name=emailupdates value="<?php echo $emailupdates ?>">
<input type=hidden name=ID value="<?php echo $ID ?>">
<input type=hidden name=is_group value="<?php echo $is_group ?>">
<input type=hidden name=other_emails value="<?php echo $other_emails ?>">

<?php
if ($is_group == 'yes')
{
	PRINT "<input type=hidden name=groupname value=\"$computername\">";
}
PRINT "<input type=hidden name=contents value=\"$contents\">";
?>
<input type=submit value="Edit Job"></form> 

<br>
<?php

PRINT "<br><strong>";
__("Priority:");
PRINT "</strong> $priority";
PRINT "<br><strong>";
__("Your Name:");
PRINT "</strong> $uname";
PRINT "<br><strong>";
__("Your E-Mail:");
PRINT "</strong> $uemail";
PRINT "<br><strong>";
__("Other E-mails:");
PRINT "</strong> $other_emails";
PRINT "<br><strong>";
__("Computer");
PRINT ":</strong> $computername ($ID) <br>";
$htmlcontents = nl2br($contents);
PRINT "<br><strong>";
__("Problem Report:");
PRINT "</strong><br>$htmlcontents<br>";

if (@$error != 1) 
{
	$contents = "By: $uname ($uemail)\n$contents";
	PRINT '<form method=post action="'
	  .Config::AbsLoc('users/tracking-add.php')
	  .'">';
	PRINT "<input type=hidden name=priority value=\"$priority\">";
	PRINT "<input type=hidden name=ID value=\"$ID\">";
	PRINT "<input type=hidden name=is_group value=\"$is_group\">";
	PRINT "<input type=hidden name=status value=new>";
	PRINT "<input type=hidden name=contents value=\"$contents\">";
	PRINT "<input type=hidden name=uemail value=\"$uemail\">";
	PRINT "<input type=hidden name=other_emails value=\"$other_emails\">";
	PRINT "<input type=hidden name=emailupdates value=\"$emailupdates\">";
	PRINT "<input type=submit value=\"Add job\"></form>";
}
 
PRINT "<br>";
commonFooter();
