#!/bin/sh
# Script to create daily backups of the IRM database by Jon Pennington,
# jpennington@atipa.com.  Released under the  GNU LESSER GENERAL PUBLIC LICENSE
# as per Version 2, June 1991.  For more information on the copying and
# licensing, see http://www.gnu.org/copyleft/lesser.html

IRM_DATE=`date '+%y%m%d'`
IRM_DUMP=/tmp/irm-$IRM_DATE.dump
IRM_BACKUP=/tmp/irm-$IRM_DATE.dump.gz
# Establishes values for variables used later.

mysqldump -u irm -ppassword irm > $IRM_DUMP &&
gzip -f $IRM_DUMP &&
# Creates the dump file and compresses it;
# -u is the IRM user, -p is the password for that user.
# The -f switch on gzip forces it to overwrite the file if one exists.

mv $IRM_BACKUP /home/irmadmin &&
chown irmadmin.users /home/irmadmin/irm-$IRM_DATE.dump.gz &&
chmod 600 /home/irmadmin/irm-$IRM_DATE.dump.gz &&
# Makes the compressed dump file property of the irmadmin user.
# Make sure that you replace irmadmin with somebody who would care ;).

echo "$IRM_BACKUP was successfully created." | mail irmadmin -s $IRM_BACKUP ||
echo "$IRM_BACKUP was NOT successfully created." | mail irmadmin -s $IRM_BACKUP
# Notifies irmadmin of (un)successful backup creation
# EOF -=|JP|=-