/*
 *  - WAV list menu tab
 */


#include <stdio.h>
#include "../ithelib.h"
#include "../gui/igui.hpp"
#include "../console.h"
#include "../core.hpp"
#include "../gamedata.h"
#include "../init.h"
#include "../gui/menusys.h"
#include "../sound.h"

// defines

#define STR_LEN 32

// variables

extern int focus,WA_Id,wav_total;
extern char **wavfiles;
static int nodrift=0;
static int curwav=0;

static int WavName_Id,WavPath_Id,WavDrift_Id;
static char str32[STR_LEN+1];

// functions

extern void Toolbar();
static void Nothing();

void GetWavName();
void GetWavPath();
void WavUpdate();                       // Update the displays
void NewWav();
void PickWav();
void DelWav();
void GetWavPitch();
static int CMP(char *a, char *b);

static int GetNumForFilename(char *str);

// GoFocal - The menu tab function.  This is called from the toolbar

void WA_GoFocal()
{
if(focus==5)            // Make sure we don't redraw if the user clicks again
	return;

memset(str32,' ',STR_LEN); str32[STR_LEN]=0;  // Make a 255 character string

focus=5;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(WA_Id);     // And make the button stick inwards

// WAV list editor.
// In the top-left corner is the sprite ID number and two movement buttons.

IG_TextButton(32,64," Add New Sound     ",NewWav,NULL,NULL);
IG_TextButton(32,96," Pick a Sound      ",PickWav,NULL,NULL);
IG_TextButton(32,128," Delete a Sound    ",DelWav,NULL,NULL);

IG_AddKey(KEY_A,NewWav);
IG_AddKey(KEY_P,PickWav);
IG_AddKey(KEY_D,DelWav);

DrawSunkBox3D(300,56,620,460);

setcolor(ITG_WHITE);
DrawScreenText(320,64,"Sound effect name:");
WavName_Id = IG_InputButton(320,80,str32,GetWavName,NULL,NULL);

DrawScreenText(320,112,"Sound filename:");
WavPath_Id = IG_InputButton(320,128,str32,GetWavPath,NULL,NULL);

WavDrift_Id = IG_ToggleButton(320,176,"Plays at random pitch",GetWavPitch,NULL,NULL,&nodrift);
IG_SetInText(WavDrift_Id,"Plays at fixed pitch ");

IG_AddKey(KEY_N,GetWavName);
IG_AddKey(KEY_F,GetWavPath);
IG_AddKey(KEY_I,GetWavPitch);

WavUpdate();
}

// Callback for a null event

void Nothing()
{
return;
}


// Callback for Setting the sprite description

void GetWavName()
{
//if(curspr<SPtot)
    InputString(-1,-1,"Enter the new description of the sound effect",32,wavtab[curwav].name);
WavUpdate();
}

// Callback for Setting the sprite filename

void GetWavPath()
{
char oldpath[128];

strcpy(oldpath,wavtab[curwav].fname);
InputNameFromListWithFunc(-1,-1,"Choose a WAV file:",wav_total-1,wavfiles,5,wavtab[curwav].fname,0,0,NULL);
if(!wavtab[curwav].fname[0])
    strcpy(wavtab[curwav].fname,oldpath);
WavUpdate();
}

// Function for updating the display

void WavUpdate()
{
int num;
// Clear the name and path, set to proper value later, if valid no.
IG_UpdateText(WavPath_Id,"");
IG_UpdateText(WavName_Id,"");

if(!wavtab[curwav].name || !wavtab[curwav].fname)
    num = -1;
else
    {
    nodrift = wavtab[curwav].nodrift;
    draw_button(WavDrift_Id);
    num = GetNumForFilename(wavtab[curwav].fname);
    IG_UpdateText(WavPath_Id,wavtab[curwav].fname);
    IG_UpdateText(WavName_Id,wavtab[curwav].name);
    }
}

int GetNumForFilename(char *str)
{
if(!str)
    return -1;
for(int ctr=0;ctr<wav_total;ctr++)
    if(wavtab[ctr].fname)
    if(!stricmp(wavtab[ctr].fname,str))
        return ctr;
return -1;
}

void PickWav()
{
char name[512];
char **mlist;
long num=0,ctr;

mlist = (char **)M_get(wav_alloc,sizeof(char *));

for(ctr=0;ctr<wav_alloc;ctr++)
    if(wavtab[ctr].name && wavtab[ctr].fname)
        mlist[num++]=wavtab[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,wavtab[curwav].name);
InputNameFromListWithFunc(-1,-1,"Choose a sound effect:",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,wavtab[curwav].name);

M_free(mlist);

for(ctr=0;ctr<wav_alloc;ctr++)
    if(wavtab[ctr].name != NULL)
    if(!stricmp(wavtab[ctr].name,name))
        {
        curwav=ctr;
        WavUpdate();
        return;
        }
Notify(-1,-1,"Oh Bugger!",NULL);
}

void NewWav()
{
long ctr;
for(ctr=0;ctr<wav_alloc;ctr++)
    if(!wavtab[ctr].name)
        {
        curwav=ctr;
        wavtab[curwav].fname = (char *)M_get(1,64);
        wavtab[curwav].name = (char *)M_get(1,64);
        strcpy(wavtab[curwav].fname,"NONE");
        strcpy(wavtab[curwav].name,"NONE");
        WavUpdate();

        GetWavPath();
        GetWavName();

        return;
        }

Notify(-1,-1,"Cannot create a new Sound effect.","Increase the value of MAX_WAVS in SCRIPTER.INI");
}

void DelWav()
{
if(curwav == 0)
    {
    Notify(-1,-1,"This entry is special and cannot be deleted.","You can still change it to something else though..");
    return;
    }

if(Confirm(-1,-1,"Really delete this sound effect?",wavtab[curwav].name))
    {
    M_free(wavtab[curwav].fname);
    M_free(wavtab[curwav].name);
    wavtab[curwav].fname = NULL;
    wavtab[curwav].name = NULL;
    wavtab[curwav].nodrift= 0;
    curwav=0;
    WavUpdate();
    }

}

int CMP(char *a,char *b)
{
return strcmp(a,b);
}

/*
int VrmInUse(int spr)
{

OBJECT *CH;
int frame,ctr;

CH = &CHlist[spr];
for(ctr=0;ctr<chr_alloc;ctr++)
   {
   if(CHlist[ctr].name)
      {
      for(frame=0;frame<SQlist[ctr].frames;frame++)
          if(SQlist[ctr].seq[frame] == SPR)
              return ctr;
      if(SQlist[ctr].overlay == SPR)
          return ctr;
      }
   }

return -1;
}
*/

void GetWavPitch()
{
WavUpdate();
nodrift = !nodrift;
wavtab[curwav].nodrift=nodrift;
IG_WaitForRelease();
}

