/**************************************************************************** 
** File: rtp.c
**
** Author: Mike Borella
**
** Comments: Dump RTP header information. 
**
** $Id: rtp.c,v 1.6 2001/05/28 19:24:04 mborella Exp $
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Library General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "global.h"
#include "rtp.h"

extern struct arg_t * my_args;

/*----------------------------------------------------------------------------
**
** dump_rtp()
**
** Parse RTP packet and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_rtp(packet_t * pkt)
{
  rtp_header_t rtp;
  u_int8_t     payload_type;
  u_int8_t     marker;
  u_int8_t     csrc_count;
  u_int8_t     extension;
  u_int8_t     padding;
  u_int8_t     version;
  u_int8_t     i;

  /* Set the layer */
  set_layer(LAYER_APPLICATION);

  /* Get the fixed RTP header */
  if (get_packet_bytes((u_int8_t *) &rtp, pkt, sizeof(rtp)) == 0)
    return;
  
  /* Conversions */
  payload_type = rtp.payload_type;
  marker = rtp.marker;
  csrc_count = rtp.csrc_count;
  extension = rtp.extension;
  padding = rtp.padding;
  version = rtp.version;

  /* Display */
  if (my_args->m)
    {
      display_minimal_string("RTP");
    }
  else
    {
      display_header_banner("RTP Header");
      display("Version", (u_int8_t *) &version, 1, DISP_DEC);
      display("Padding", (u_int8_t *) &padding, 1, DISP_DEC);
      display("Extension", (u_int8_t *) &extension, 1, DISP_DEC);
      display("CSRC count", (u_int8_t *) &csrc_count, 1, DISP_DEC);
      display("Marker", (u_int8_t *) &marker, 1, DISP_DEC);
      display("Payload type", (u_int8_t *) &payload_type, 1, DISP_DEC);
      display("Sequence number", (u_int8_t *) &rtp.seqno, 2, DISP_DEC);
      display("Timestamp", (u_int8_t *) &rtp.timestamp, 4, DISP_DEC);
      display("SSRC", (u_int8_t *) &rtp.ssrc, 4, DISP_DEC);

      /* Dump contributing sources */

      for (i=0; i < csrc_count; i++)
	{
	  u_int32_t csrc;
	  if (get_packet_bytes((u_int8_t *) &csrc, pkt, sizeof(u_int32_t)) 
	      == 0)
	    return;
	  display("CSRC", (u_int8_t *) &csrc, 4, DISP_DEC);
	}
    }
  
}
