// -*- C++ -*-
// --------------------------------------------------------------------
// Dialogs
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef DIALOGS_H
#define DIALOGS_H

#include "dlgdocprop.h"
#include "dlgpref.h"
#include "dlgdirprefs.h"
#include "dlgpagepres.h"
#include "dlglatexerr.h"

#include "ipedoc.h"
#include "ipeprefs.h"
#include "ipepage.h"

#include <qstringlist.h>

// --------------------------------------------------------------------

class DialogDocumentProperties : public DlgDocumentProperties {
  Q_OBJECT
public:
  DialogDocumentProperties(QWidget* parent, IpeDocument::SProperties &data,
			   const IpeStyleSheet *sheet);
public slots:
  virtual void UpdateData();
  virtual void ShowHelp();
  virtual void SetDefaultMedia();

private:
  IpeVector GetMedia();

private:
  IpeDocument::SProperties &iData;
  const IpeStyleSheet *iSheet;
  bool iCustomMedia;
};

// --------------------------------------------------------------------

class DialogDirPreferences : public DlgDirectories {
  Q_OBJECT

public:
  DialogDirPreferences(QWidget* parent, IpePreferences &data);

public slots:
  void ShowHelp();

private:
  IpePreferences &iData;
};

// --------------------------------------------------------------------

class DialogPreferences : public DlgPreferences {
  Q_OBJECT

public:
  DialogPreferences(QWidget* parent, IpePreferences &data, int gridSize);

public slots:
  void ShowHelp();
  void UpdateData();
  void ShowDirectories();
  void SetFont();
  void SetTextFont();
  void SetStyleSheet();
  void ClearStyleSheet();
  void SetDefaultGrid();

private:
  IpePreferences &iData;
  QString iStyleSheetPath;
  int iGridSize;
};

// --------------------------------------------------------------------

class DialogPageViews : public DlgPagePresentation {
  Q_OBJECT
public:
  DialogPageViews(QWidget* parent, QStringList layers, IpeViewSeq &data,
		  QStringList &sections);

public slots:
  virtual void AddNewView();
  virtual void MoveViewUp();
  virtual void RemoveView();
  virtual void ShowHelp();
  virtual void MoveViewDown();
  virtual void EffectChanged(int effectNo);
  virtual void LayerHighlighted();
  virtual void CurrentViewChanged(QListBoxItem *);
  virtual void TransitionChanged(int);
  virtual void DurationChanged(int);
  virtual void UpdateData();

private:
  void UpdateFields();
  void UpdateViewLine(int itemno);
  void UpdateViewState();

private:
  QStringList iLayers;
  IpeViewSeq &iData;
  QStringList &iSections;
  int iCurView;
  bool iInternal;
};

// --------------------------------------------------------------------

class DialogLatexError : public DlgLatexErr {
  Q_OBJECT
public:
  DialogLatexError(QWidget* parent, QString log);
};

// --------------------------------------------------------------------
#endif
