/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  widget.cc - C++ wrapper implementation for the GtkGLExt widget functions.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "widget.h"
#include "../../gdk/gl/config.h"
#include "../../gdk/gl/context.h"
#include "../../gdk/gl/drawable.h"
#include "../../gdk/gl/window.h"
#include <inti/glib/object.h>

using namespace Inti;

/*  Gtk::GL::Widget
 */

Gtk::GL::Widget::~Widget()
{
}

bool
Gtk::GL::Widget::is_gl_capable() const
{
	g_return_val_if_fail(is_a(GTK_TYPE_WIDGET), false);
	return gtk_widget_is_gl_capable((GtkWidget*)instance);
}

Gdk::GL::Config*
Gtk::GL::Widget::get_gl_config() const
{
	g_return_val_if_fail(is_a(GTK_TYPE_WIDGET), 0);
	return G::Object::wrap<Gdk::GL::Config>(gtk_widget_get_gl_config((GtkWidget*)instance));
}

Gdk::GL::Context*
Gtk::GL::Widget::get_gl_context() const
{
	g_return_val_if_fail(is_a(GTK_TYPE_WIDGET), 0);
	return G::Object::wrap<Gdk::GL::Context>(gtk_widget_get_gl_context((GtkWidget*)instance));
}

Gdk::GL::Window*
Gtk::GL::Widget::get_gl_window() const
{
	g_return_val_if_fail(is_a(GTK_TYPE_WIDGET), 0);
	return G::Object::wrap<Gdk::GL::Window>(gtk_widget_get_gl_window((GtkWidget*)instance));
}

Gdk::GL::Drawable*
Gtk::GL::Widget::get_gl_drawable() const
{
	g_return_val_if_fail(is_a(GTK_TYPE_WIDGET), 0);
	Gdk::GL::Window *glwindow = G::Object::wrap<Gdk::GL::Window>(gtk_widget_get_gl_window((GtkWidget*)instance));
	return static_cast<Gdk::GL::Drawable*>(glwindow);
}

Pointer<Gdk::GL::Context>
Gtk::GL::Widget::create_gl_context(bool direct, int render_type)
{
	g_return_val_if_fail(is_a(GTK_TYPE_WIDGET), 0);
	return G::Object::wrap<Gdk::GL::Context>(gtk_widget_create_gl_context((GtkWidget*)instance, 0, direct, render_type));
}

Pointer<Gdk::GL::Context>
Gtk::GL::Widget::create_gl_context(const Gdk::GL::Context& share_list, bool direct, int render_type)
{
	g_return_val_if_fail(is_a(GTK_TYPE_WIDGET), 0);
	return G::Object::wrap<Gdk::GL::Context>(gtk_widget_create_gl_context((GtkWidget*)instance, share_list.gdk_gl_context(), direct, render_type));
}

bool
Gtk::GL::Widget::set_gl_capability(const Gdk::GL::Config& glconfig, bool direct, int render_type)
{
	g_return_val_if_fail(is_a(GTK_TYPE_WIDGET), false);
	return gtk_widget_set_gl_capability((GtkWidget*)instance, glconfig.gdk_gl_config(), 0, direct, render_type);
}

bool
Gtk::GL::Widget::set_gl_capability(const Gdk::GL::Config& glconfig, const Gdk::GL::Context& share_list, bool direct, int render_type)
{
	g_return_val_if_fail(is_a(GTK_TYPE_WIDGET), false);
	return gtk_widget_set_gl_capability((GtkWidget*)instance, glconfig.gdk_gl_config(), share_list.gdk_gl_context(), direct, render_type);
}

