/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//! @file inti/gtk/gl/init.h
//! @brief A C++ wrapper interface for the GtkGLExt initialization functions.

#ifndef INTI_GTK_GL_INIT_H
#define INTI_GTK_GL_INIT_H

#ifndef __GTK_GL_INIT_H__
#include <gtk/gtkglinit.h>
#endif

namespace Inti {

namespace Gtk {

namespace GL {

//! @name Intialization Methods
//! @{

void init(int *argc, char ***argv);
//!< Initialize the Inti-GL library.
//!< @param argc The address of the argc parameter of your main() function.
//!< @param argv The address of the argv parameter of main().
//!<
//!< <BR>Call this method before using any other Gtk::GL functions in your applications.
//!< It will initialize everything needed to operate the library and parses some standard
//!< command line options. <EM>argc</EM> and <EM>argv</EM> are adjusted accordingly so
//!< your own code will never see those standard arguments.
//!<
//!< <B>Note:</B> This method will terminate your program if it was unable to initialize
//!< the library for some reason. If you want your program to fall back to a textual
//!< interface you want to call Gtk::GL::init_check() instead. Any <EM>argv</EM> parameters
//!< understood by Gtk::GL::init() are stripped before returning and <EM>argc</EM> changed
//!< accordingly.

bool init_check(int *argc, char ***argv);
//!< Initialize the Inti-GL library.
//!< @param argc The address of the argc parameter of your main() function.
//!< @param argv The address of the argv parameter of main().
//!< @return <EM>true</EM> if the GUI has been successfully initialized, <EM>false</EM> otherwise.
//!<
//!< <BR>This method does the same work as Gtk::GL::init() with only a single change:
//!< It does not terminate the program if the library can't be initialized. Instead it
//!< returns false on failure. This way the application can fall back to some other means
//!< of communication with the user - for example a curses or command line interface.
//!<
//!< Any <EM>argv</EM> parameters understood by Gtk::GL::init() are stripped before returning
//!< and <EM>argc</EM> changed accordingly.

bool parse_args(int *argc, char ***argv);
//!< Parses command line arguments, and initializes global attributes of GtkGLExt.
//!< @param argc The number of command line arguments.
//!< @param argv The array of command line arguments.
//!< @return <EM>true</EM> if initialization succeeded, otherwise <EM>false</EM>.
//!<
//!< <BR>Any arguments used by GtkGLExt are removed from the array and <EM>argc</EM>
//!< and <EM>argv</EM> are updated accordingly. You shouldn't call this function
//!< explicitely if you are using Gtk::GL::init(), or Gtk::GL::init_check().

//! @}

} // namespace GL

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_GL_INIT_H

