/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  drawable_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_GDK_GL_DRAWABLE_CLASS_H
#define INTI_GDK_GL_DRAWABLE_CLASS_H

namespace Inti {

namespace Gdk {

namespace GL {

class DrawableClass
{
public:
	static void init(GdkGLDrawableClass *g_iface);

	static GdkGLContext* create_new_context_proxy(GdkGLDrawable *gldrawable, GdkGLContext *share_list, gboolean direct, int render_type);

	static gboolean make_context_current_proxy(GdkGLDrawable *gldrawable, GdkGLDrawable *read, GdkGLContext *glcontext);

	static gboolean is_double_buffered_proxy(GdkGLDrawable *gldrawable);

	static void swap_buffers_proxy(GdkGLDrawable *gldrawable);

	static void wait_gl_proxy(GdkGLDrawable *gldrawable);

	static void wait_gdk_proxy(GdkGLDrawable *gldrawable);

	static gboolean gl_begin_proxy(GdkGLDrawable *gldrawable, GdkGLDrawable *read, GdkGLContext *glcontext);

	static void gl_end_proxy(GdkGLDrawable *gldrawable);

	static GdkGLConfig* get_gl_config_proxy(GdkGLDrawable *gldrawable);

	static void get_size_proxy(GdkGLDrawable *gldrawable, gint *width, gint *height);
};

} // namespace GL

} // namespace Gdk

} // namespace Inti

#endif // INTI_GDK_GL_DRAWABLE_CLASS_H
