/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  font.cc - A C++ wrapper interface for the OpenGL font functions.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "font.h"
#include <inti/gdk/display.h>

using namespace Inti;

/*  Gdk::GL::font_use_pango_font
 */

Pango::Font*
Gdk::GL::font_use_pango_font(const Pango::FontDescription& font_desc, int first, int count, int list_base, const Display *display)
{
	GdkDisplay *tmp_display = display ? display->gdk_display() : gdk_display_get_default();
	return G::Object::wrap<Pango::Font>(gdk_gl_font_use_pango_font_for_display(tmp_display,
	                                    font_desc.pango_font_description(),
	                                    first, count, list_base));
}

