#include "../config.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

void print_event_descriptions() {
	printf("\taccess\t\tfile or directory contents were read\n");
	printf("\tmodify\t\tfile or directory contents were written\n");
	printf("\tattrib\t\tfile or directory attributes changed\n");
	printf("\tclose_write\tfile or directory closed, after being opened in\n"
	       "\t           \twriteable mode\n");
	printf("\tclose_nowrite\tfile or directory closed, after being opened in\n"
	       "\t           \tread-only mode\n");
	printf("\tclose\t\tfile or directory closed, regardless of read/write "
	       "mode\n");
	printf("\topen\t\tfile or directory opened\n");
	printf("\tmoved_to\tfile or directory moved to watched directory\n");
	printf("\tmoved_from\tfile or directory moved from watched directory\n");
	printf("\tmove\t\tfile or directory moved to or from watched directory\n");
	printf("\tcreate\t\tfile or directory created within watched directory\n");
	printf("\tdelete\t\tfile or directory deleted within watched directory\n");
	printf("\tdelete_self\tfile or directory was deleted\n");
	printf("\tunmount\t\tfile system containing file or directory unmounted\n");
}

int isdir( char const * path ) {
	static struct stat64 my_stat;

	if ( -1 == lstat64( path, &my_stat ) ) {
		fprintf(stderr, "Stat failed on %s: %s\n", path, strerror(errno));
		return 0;
	}

	return S_ISDIR( my_stat.st_mode ) && !S_ISLNK( my_stat.st_mode );
}
