/***************************************************************************
                          config.cpp  -  description
                             -------------------
    begin                : Wed May 2 2001
    copyright            : (C) 2001 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"
#include <fstream.h>
#include <list>
#include <string>


bool Config::load( string file)
{
  filename = file;

  typedef multimap<string, string, less<string> > StringMultiMap;
  typedef StringMultiMap::value_type StringMMPair;


  StringMultiMap parsed_map;
  list<string> keys;

  char line[1024];

  ifstream f( file. c_str(), ios::in );
  if( !f ) {
    cerr << "Unable to open file '"<<file<<"'"<<endl;
    return false;
  }

  // read the header, and ignore it.
  f.getline( line, 1024, '\n' );

  if( strcmp(line, "[Config]") != 0 ) {
    cerr << "Invalid file format." << endl;
    return false;
  }

  string section;
  string value;
  string key;
  string tmp;

  while( !f.eof() )
  {
    f.getline( line, 1024, '\n' );
    tmp = line;
    //ignore whitelines.
    if( tmp.size() != 0 ) {
      if( tmp[0] == '[' ) {
        //cerr << "Section:"<<section<<endl;
        section = tmp;
        keys.insert( keys.end(), section );
      } else {
        //cerr << section << ":" << tmp << endl;
        parsed_map.insert( StringMMPair( section, tmp ) );
      }
     } else {
        //cerr << "Config: empty line"<<endl;
     }

  }
  //close the file.
  f.close();

  //we now have all the sections parse into a multimap, so
  //now it's time to format everything.
  list<string>::iterator kit = keys.begin();

  while( kit != keys.end() )
  {
    section = *kit;

    StringMultiMap::iterator start = parsed_map.lower_bound( section );
    StringMultiMap::iterator end = parsed_map.upper_bound( section );

    //format the section
    section = section.substr( 1, section.size()-2 );

    while( start != end )
    {
      tmp = start -> second;
      int tk = tmp.find_first_of('=');
      key = tmp.substr(0, tk);
      value = tmp.substr( tk+1, tmp.size()-1 );
//      cerr << "["<<section<<"]"<<key<<"="<<value<<endl;
      setString( section, key, value );

      ++start;
    }

    ++kit;

  }


  return true;


}
bool Config::save( string file)
{
  ofstream f( file . c_str() , ios::out );

  if( !f ) {
    cerr << "Unable to open file '"<<file<<"'"<<endl;
    return false;
  }

  f << "[Config]" << endl;

  SectionMap::iterator cit = config.begin();
  StringMap::iterator sit;
  while( cit != config.end() )
  {
    //start a section
    f << "[" << cit -> first << "]" << endl;
    StringMap *m = cit -> second;
    sit = m -> begin();

    while( sit != m -> end() )
    { //write each key value pair.
//      cerr << "["<<cit -> first <<"]"<< sit -> first << "=" << sit -> second << endl;
      f << sit -> first << "=" << sit -> second << endl;
      ++sit;
    }

    ++cit;
  }

  f.close();
  return true;

}
bool Config::save()
{
  return save( filename );
}

void Config::setSection  ( string s )
{
  current_section = s;
}
	
string Config::getString ( string s )
{
  if( current_section == "" ) {
    cerr << "Section not set."<<endl;
    return "";
  }

  SectionMap::iterator it = config.find( current_section );
  if( it == config.end() ) {
    cerr << "Unknown section '"<<current_section <<"'"<< endl;
    return "";
  }

  StringMap *m = it -> second;

  StringMap::iterator its = m -> find( s );
  if( its == m -> end() ) {
    cerr << "Unknown value '"<<s<<"' in section '"<<current_section<<"'"<<endl;
    return "";
  }

  return its -> second;
}
int Config::getInt    ( string s )
{
  string value = getString( s );
  if( value == "" )
    return -1;
  else
    return atoi( value.c_str() );


}
float Config::getFloat  ( string s )
{
  string value = getString( s );
  if( value == "" )
    return -1;
  else
    return atof( value.c_str() );


}
bool Config::getBool   ( string s )
{
  string value = getString( s );
  if (value == "" )
    return false;
  else if(value == "1")
    return true;
  else
    return false;
}
	
void Config::setInt   ( string key, int v)
{
  char num[256];
  sprintf(num, "%d", v );
  setString( key, num );

}
void Config::setFloat ( string key, float v)
{
  char num[256];
  sprintf(num, "%f", v );
  setString( key, num );

}
void Config::setString( string key, string v)
{
  StringMap *m;
  SectionMap::iterator it = config.find( current_section );

  if( it == config.end() ) {

//    cerr << "Creating section '"<<current_section<<"'"<<endl;
    m = new StringMap();
    config.insert( Section( current_section, m ) );

  } else {

    m = it -> second;

  }

  (*m) [key] = v;// -> insert( StringPair( key, v ) );
  return;

}
void Config::setBool  ( string key, bool v)
{
  if( v )
    setString( key, "1" );
  else
    setString( key, "0" );
}
	
/** Used mostly for loading in from a file
  */
void Config::setString( string section, string key, string value )
{
  SectionMap::iterator it = config.find( section );
  if( it != config.end() ) {

    StringMap *m = it -> second;
    m -> insert( StringPair( key, value ) );
    return;

  } else {

    StringMap *m = new StringMap;
    m -> insert( StringPair(  key, value ) );
    config.insert( Section( section, m ) );
    return;

  }

}

/** Adds a default value that will be used if the key is not found. */
string Config::getString(string sect, string key, string default_val){
    setSection( sect);
    string t_str = getString( key );
    if ( t_str == "" ) {
    		setString( key, default_val );
        t_str = default_val;
    }
    return t_str;
}
