/***************************************************************************
                        viewYZ.h  -  description          
                            -------------------                     
   begin                : Thu Apr 8 1999                    
   copyright            : (C) 1999 by Jonathan E. Anderson           
   email                : janderson@onelink.com            
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef VIEWYZ_H
#define VIEWYZ_H

#include "glview.h"


/** ViewYZ is a YZ openGL view.
 *  
 *@author Jonathan E. Anderson
 */

class ViewYZ : public GLView
{
      Q_OBJECT
   public:
      ViewYZ( QWidget *parent, const char *name = 0, QGLWidget *sharer = 0 );
      ~ViewYZ();

      void initView();
      void display();
      void setCamera();
      void setProjection();

      void moveCamera( float x, float y );
      void rotateCamera( float x, float y );
      void zoomCamera( float x, float y );

      int getViewType() { return VYZ;};

      void drawBackground();
      void drawGrid();
      void setWireframe2D( bool b );

      Vector4 &unProjectPoint( int x, int y );

      Grid *m_grid;

};

#endif

































































