/***************************************************************************
                         viewUV.h  -  description
                            -------------------                                         
   begin                : Sun Sep 26 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef VIEWUV_H
#define VIEWUV_H

#include "viewXY.h"


class Mesh;

class Face;

/**This view is used for UV editing
  *@author Jon Anderson
  */


class ViewUV : public ViewXY
{
      Q_OBJECT
   public:
      ViewUV( QWidget *parent, const char *name = 0, QGLWidget *sharer = 0, bool enable = false );
      ~ViewUV();

      void display();
      void setCamera();
      void setProjection();
      void setMesh( Mesh *_m, vector<int> & );
      //  void setFaces(FaceList &flist);

      virtual void setControl( IControl *c ) {uv_modifier = c;};

      void determineBounds();

      void drawBackground();


      virtual IControl * currentControl() { return uv_modifier;};

   public slots:
      void setURepeat( int x );
      void setVRepeat( int x );

   signals:
      void vRepeat( int );
      void uRepeat( int );

   protected:

      // void mouseMoveEvent(QMouseEvent *event);
      // void mousePressEvent(QMouseEvent *event);
      // void mouseReleaseEvent(QMouseEvent *event);

   private:

      // FaceList faces;
      vector<int> faces;
      //  Vector4 mPressed;
      //  Vector4 mCurrent;
      //  Vector4 mRelease;

      int urepeat;
      int vrepeat;

      Mesh *mesh;

      IControl *uv_modifier;

      float min_u;
      float max_u;
      float min_v;
      float max_v;

};

#endif





















