/***************************************************************************
                          cylinderwrap.cpp  -  description
                             -------------------
    begin                : Sat Oct 14 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cylinderwrap.h"
#include <Entities/face.h>
#include <Entities/vertex.h>
#include <math.h>

CylinderWrap::CylinderWrap():UVWrap()
{
	gluObj = gluNewQuadric();
   gluQuadricDrawStyle(gluObj, GLU_LINE);
   gluQuadricNormals(gluObj, GL_SMOOTH);
   gluQuadricTexture(gluObj, GL_TRUE);
}
CylinderWrap::~CylinderWrap()
{
	gluDeleteQuadric(gluObj);
}
Entity * CylinderWrap::clone()
{
	UVWrap *v = new CylinderWrap();
	*v = *this;
	return v;
}	

int CylinderWrap::draw(int d_options = 0)
{
		
	glPushMatrix();
		
	Matrix44 m;
	getCompleteMatrix(&m);
	glMultMatrixf((GLfloat *)(m.m));
	glLineWidth( 2 );
	glColor4f(.5, 0, 0, 1);
	glRotatef(-90, 1, 0, 0);	
	gluCylinder(gluObj, .5 * m_scale.x, .5 * m_scale.x, 1 * m_scale.z, 10, 10);	
	
	glLineWidth( 1 );
	glPopMatrix();

	return 0;
}

void CylinderWrap::createMapping(vector<SubObject  *> *faces)
{
	Face *f;
	int num_verts;
	Matrix44 m;
	Vector4 uv;
	
	getCompleteMatrix(&m);
	m.Invert();
	
	for(int i=0; i<(int)faces->size(); i++){
		f = (Face *) (*faces)[i];
		num_verts = f->getNumVerts();
		for(int j=0; j<num_verts; j++){
			//transform the point into the planes space.
			Vector4 pt;
			f->getVertPtr(j) -> getTransformedPosition( &pt);
			pt = m * pt;
			
			uv.x = 1 - (atan2(pt.x, -pt.z) / (2 * M_PI) + 0.5);
			uv.y = pt.y; //keep the height...
			
			uv.y /= m_scale.z;
		
			
			f -> setUVCoord(j, uv);
		}
		f -> normalizeUVs(true, false);
				
	}

}
