/***************************************************************************
                          cubewrap.cpp  -  description
                             -------------------
    begin                : Tue May 15 2001
    copyright            : (C) 2001 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cubewrap.h"
#include <Entities/face.h>
#include <Entities/vertex.h>

CubeWrap::CubeWrap() : UVWrap()
{

}
CubeWrap::~CubeWrap()
{

}
Entity * CubeWrap::clone()
{
	UVWrap *v = new CubeWrap();
	*v = *this;
	return v;
}	
int CubeWrap::draw(int d_options = 0)
{
		
	glPushMatrix();
		
	Matrix44 m;
	getCompleteMatrix(&m);
	glMultMatrixf((GLfloat *)(m.m));
	
	glColor4f(.5, 0, 0, 1);

	glBegin(GL_LINE_LOOP);
		glVertex3f( 0            , 0,  0            );
		glVertex3f( 1 * m_scale.x, 0,  0            );
		glVertex3f( 1 * m_scale.x, 0,  -1 * m_scale.z);
		glVertex3f( 0 * m_scale.x, 0,  -1 * m_scale.z);
	glEnd();	

	glBegin(GL_LINES);
		glColor4f(.5, 0, 0, 1);
		glVertex3f(0, 0, 0              );
		glVertex3f(0, 0, -1.5 * m_scale.z);
		glColor4f(0, .5, 0, 1);
		glVertex3f(0, 0, 0              );
		glVertex3f(1.5 * m_scale.x, 0, 0);
	glEnd();
	

		
	glPopMatrix();

	return 0;
}


void CubeWrap::createMapping(vector<SubObject  *> *faces)
{
	Face *f;
	int num_verts;
	Matrix44 m;
	Vector4 uv;
	
	getCompleteMatrix(&m);
	m.Invert();
	
	for(int i=0; i<(int)faces->size(); i++){
		f = (Face *) (*faces)[i];
		num_verts = f->getNumVerts();
		for(int j=0; j<num_verts; j++){
			//transform the point into the planes space.
			
			/* Find the normal of each face, and determine the plane
			 * to use for mapping.
			 */
			
			/*
			Vector4 pt;
			f->getVertPtr(j) -> getTransformedPosition( &pt);
			pt = m * pt;
			
			
			uv.x = pt.x;
			uv.y = - pt.z;
			
			uv.x /= m_scale.x;
			uv.y /= m_scale.z;
			
			f -> setUVCoord(j, uv);
			*/
		}
				
	}

}
