/***************************************************************************
                          dynamiclibrary.cpp  -  description
                             -------------------
    begin                : Fri Feb 11 2000
    copyright            : (C) 2000 by Jon Anderson, Will DeVore
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dynamiclibrary.h"

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>

#include "ltdl.h"

DynamicLibrary::DynamicLibrary()
{
	libHandle = 0;
}

DynamicLibrary::DynamicLibrary(const char * libName)
{
	libHandle = 0;
	loadLibrary(libName);
}


DynamicLibrary::~DynamicLibrary()
{
	unloadLibrary();
}
bool DynamicLibrary::loadLibrary(const char * libName)
{

	if (libName != 0 && ::strlen(libName) > 0) {
		if (libHandle == 0){
			libHandle = ::lt_dlopen( libName ); //RTLD_LAZY); // RTLD_LAZY OR RTLD_NOW | RTLD_GLOBAL
		}
		if(libHandle == 0)
			cerr << ::lt_dlerror()<<endl;
	}
	
	return (libHandle != 0);
}

bool DynamicLibrary::unloadLibrary()
{
	if (libHandle != 0){
		::lt_dlclose( libHandle );
	}

	libHandle = 0;
//	cache.clear();
	return true;
}
	
lt_dlfunction DynamicLibrary::getProcAddr(const char *procName) const
{
 	lt_dlfunction proc = 0;

	if (libHandle != 0){
		proc = (lt_dlfunction) ::lt_dlsym(libHandle, procName);
	}
	if(proc == 0)
		cerr<< ::lt_dlerror()<<endl;

	return  proc ;
}



