/***************************************************************************
                         splinecreator.cpp  -  description
                            -------------------
   begin                : Thu Apr 19 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "splinecreator.h"
#include <Entities/line.h>
#include <Entities/nurbscurve.h>
#include <Entities/poly.h>
#include <i3d.h>
#include <i3dworkspace.h>
#include "vertexmodifier.h"


int SplineCreator::TYPE = IControl::getUID();

SplineCreator::SplineCreator() : Creator()
{
   setName( "&Spline..." );
   m_popup -> insertItem( "&Line", this, SLOT( slotCreateLine() ) );
   m_popup -> insertItem( "&C-Curve", this, SLOT( slotCreateCCurve() ) );
   m_popup -> insertItem( "&P-Curve", this, SLOT( slotCreatePCurve() ) );
   m_popup -> insertItem( "P&olygon", this, SLOT( slotCreatePoly() ) );
   m_popup -> insertItem( "Ci&rcle", this, SLOT( slotCreateCircle() ) );

   m_spline = 0;
   m_first = true;
}

SplineCreator::~SplineCreator()
{
}


void SplineCreator::mousePress ( Vector4 &plane, Vector4 &pt, int btn )
{
   if ( m_spline != 0 )
   {
      cerr << "Extending spline" << endl;

      if ( m_spline -> numVerts() == 0 )
      {

         TransactionCommand * c = new TransactionCommand();
         Command *dbc = new DBCommand( m_spline, ADD );
         dbc -> execute();

         Command *pc = new CheckPointCmd( m_spline );
         m_spline -> extend( pt );

         c -> addCommand( dbc );
         c -> addCommand( pc );
         c -> save();

      }

      else
      {

         Command *c = new CheckPointCmd( m_spline );
         c->save();
         m_spline -> extend( pt );

      }

   }

   else
   {
      cerr << "No spline to extend." << endl;
   }

}

void SplineCreator::keyEvent( QKeyEvent *key )
{
   if ( key->key() == Key_Space )
   {
      if ( m_spline != 0 )
      {
         //      m_spline -> center();
      }

      //    m_spline = 0;

      I3D::getWorkspace() -> revertControl();
   }

   setStatusDone();
}

void SplineCreator::activate()
{
   I3D::activateControl( VertexModifier::TYPE );
   I3D::setModeMsg( " Create Mode " );
   I3D::getWorkspace() -> setCurrentControl( this );
}

void SplineCreator::deactivate()
{

   if ( m_spline != 0 && m_spline -> numVerts() == 0 )
      delete m_spline;
}

void SplineCreator::slotCreateLine()
{

   activate();
   m_spline = new Line( );
   setStatus( "Creating line:  Click to add pts. Space to Quit" );
}

void SplineCreator::slotCreateCCurve()
{

   activate();
   m_spline = new NurbsCurve( 0, CONTROL_CURVE );
   setStatus( "Creating curve from control points:  Click to add pts. Space to Quit" );
}

void SplineCreator::slotCreatePCurve()
{

   activate();
   m_spline = new NurbsCurve( 0, INTERPOLATE_CURVE );
   setStatus( "Creating curve by interpolating points:  Click to add pts. Space to Quit" );

}

void SplineCreator::slotCreatePoly()
{

   activate();
   m_spline = new Poly( );
   setStatus( "Creating n-sided polygon:  Click to add pts. Space to Quit" );
}

void SplineCreator::slotCreateCircle()
{

   m_first = true;
   activate();
   m_spline = new NurbsCurve( 0, CIRCLE_CURVE );
   setStatus( "Creating circle:  Click to add pts. Space to Quit" );
}

