/***************************************************************************
                         modetoolbar.h  -  description
                            -------------------
   begin                : Mon Apr 16 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MODETOOLBAR_H
#define MODETOOLBAR_H

#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qcombobox.h>
#include <qbuttongroup.h>
#include <Math/vector4.h>

#include "i3d.h"     // For getting settings
#include "../config.h"

/**
  *@author Jon Anderson
  */

class ModeToolbar : public QObject
{
      Q_OBJECT

   public:

      ~ModeToolbar();

      enum { MODE_SELECT, MODE_ROTATE, MODE_MOVE, MODE_SCALE_FREE, MODE_SCALE_UNIFORM };

      void init( QToolBar * );

      static bool isMultipleSelect();
      static int getMode();
      static Vector4 & getAxis();

      static ModeToolbar * getInstance();

      static void setMode( int );
      static void setMultipleSelect( bool );
      static void toggleMultipleSelect( );

      static void setAxis( Vector4 & );
      static void toggleAxis( Vector4 & );


      QToolBar *m_toolbar;
      QToolButton *btnX;
      QToolButton *btnY;
      QToolButton *btnZ;
      QComboBox *m_mode;
      QButtonGroup *m_group;
      static ModeToolbar *m_instance;

      int m_mouse_mode;
      Vector4 m_axis;

   public slots:
      void select( int );



   protected:
      ModeToolbar();

};

#endif
