/***************************************************************************
                         icontrol.cpp  -  description
                            -------------------
   begin                : Mon Apr 16 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "icontrol.h"
#include <i3d.h>


int IControl::_type = 0;

int IControl::TYPE = IControl::getUID();

IControl::IControl()
{
   m_popup = new QPopupMenu();
   m_name = "Unknown";
   //connect(m_popup, SIGNAL( aboutToHide() ), this, SLOT( slotUpdateViews() ) );
}

IControl::~IControl()
{
}

/**
  * Tells the main application to update all GL views.
  */
void IControl::updateViews()
{
   I3D::updateViews();
}

/**
  * Sets the status message.
  */
void IControl::setStatus( char *c )
{
   I3D::getInstance() ->slotStatusMsg( c );
}

/**
  * Sets the status message to "Ready."
  */
void IControl::setStatusDone()
{
   I3D::getInstance() ->slotStatusHelpMsg( "Ready." );
}

int IControl::getControlType() { return m_control_type; }

void IControl::setControlType( int i ) { m_control_type = i; }

void IControl::slotUpdateViews()
{
   cerr << "SLOT::updating views" << endl;
   updateViews();
}

//ignore these by default
void IControl::cut(){};
void IControl::copy(){};
void IControl::paste(){};

