/***************************************************************************
                         bonemodifier.cpp  -  description
                            -------------------
   begin                : Sun Apr 29 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "bonemodifier.h"
#include <Entities/bone.h>
#include "cbonedlg.h"
#include "modetoolbar.h"

#include <i3d.h>
#include <i3dworkspace.h>
#include <Commands/transactioncommand.h>
#include <Commands/checkpointcmd.h>

#define BEGIN(c,n) \
  if(assertSelectedExactly(n)){ \
    setStatus( c ); \
    TransactionCommand *tc = new TransactionCommand(); \
    CheckPointCmd *pc = new CheckPointCmd( static_cast<Entity *> ( getFirst() ) );

#define END() \
    tc -> addCommand( pc ); \
    tc -> save(); \
    setStatusDone(); \
  } \
  updateViews();



int BoneModifier::TYPE = IControl::getUID();

BoneModifier::BoneModifier() : ObjectModifier( "Bones", Bone::TYPE )
{
   setName( "&Bones" );

   m_popup -> insertSeparator();
   QPopupMenu *child = new QPopupMenu();
   child -> insertItem( "XY Joint", this, SLOT( slotAddXY() ) );
   child -> insertItem( "XZ Joint", this, SLOT( slotAddXZ() ) );
   child -> insertItem( "YZ Joint", this, SLOT( slotAddYZ() ) );
   child -> insertItem( "Ball Joint", this, SLOT( slotAddBall() ) );

   m_popup -> insertItem( "Add Child Bone", child );
   QPopupMenu *smenu = new QPopupMenu();
   smenu -> insertItem( "Save Affected And Offsets", this, SLOT( slotSaveAffectedAndOffsets() ) );
   smenu -> insertItem( "Save Affected And Offsets R", this, SLOT( slotSaveAffectedAndOffsetsR() ) );
   smenu -> insertItem( "Save Affected", this, SLOT( slotSaveAffected() ) );
   smenu -> insertItem( "Save Affected R", this, SLOT( slotSaveAffectedR() ) );
   smenu -> insertItem( "Save Offsets  ", this, SLOT( slotSaveOffsets() ) );
   smenu -> insertItem( "Save Offsets R", this, SLOT( slotSaveOffsetsR() ) );
   smenu -> insertItem( "Reset Affected ", this, SLOT( slotResetAffected() ) );
   smenu -> insertItem( "Reset Affected R", this, SLOT( slotResetAffectedR() ) );

   m_popup -> insertItem( "Deformation", smenu );

   QPopupMenu *mmenu = new QPopupMenu();

   mode_normal = mmenu -> insertItem( "Normal", this, SLOT( slotNormal() ) );
   mode_envelope = mmenu -> insertItem( "Envelope", this, SLOT( slotEnvelope() ) );
   mode_ik = mmenu -> insertItem( "IK", this, SLOT( slotIK() ) );
   mode_limits = mmenu -> insertItem( "IK Limits", this, SLOT( slotLimits() ) );

   m_popup -> insertItem( "Modify type", mmenu );
   m_popup -> insertSeparator();

   draw_affected = m_popup -> insertItem( "Highlight Affected", this, SLOT( slotToggleAffected() ) );
   draw_envelope = m_popup -> insertItem( "Always show envelope", this, SLOT( slotToggleEnvelope() ) );
   draw_limits = m_popup -> insertItem( "Show IK Limits", this, SLOT( slotToggleLimits() ) );
   m_popup -> insertSeparator();
   m_popup -> insertItem( "Properties...", this, SLOT( slotProperties() ) );

   m_popup -> setItemChecked( draw_affected, Bone::draw_affected );
   m_popup -> setItemChecked( draw_envelope, Bone::draw_envelope );
   m_popup -> setItemChecked( mode_normal, true );


   // context_menu -> insertItem( "Toggle

}

BoneModifier::~BoneModifier()
{
}

void BoneModifier::activate()
{
   clearSelection();
   I3D::getWorkspace() -> setCurrentControl( this );
   I3D::setModeMsg( " Bone Mode " );
   SelectMode::set( Bone::TYPE );
   //change to select mode immediately.
   ModeToolbar::setMode( ModeToolbar::MODE_SELECT );

   updateViews();
}

void BoneModifier::deactivate()
{
}

void BoneModifier::slotAddXY()
{
   BEGIN( "Adding XY bone...", 1 );
   Bone * parent = static_cast<Bone *>( getFirst() );
   Bone * b = new Bone( parent, 1 );
   b -> setStiffness( 5 );
   b -> setLength( 1 );
   b -> setXRot( 0, 0 );
   b -> setYRot( 0, 0 );
   b -> setZRot( -90, 90 );
   DBCommand * db = new DBCommand( b, ADD );
   db -> execute();
   tc -> addCommand( db );
   END();
}

void BoneModifier::slotAddXZ()
{
   BEGIN( "Adding XZ bone...", 1 );
   Bone * parent = static_cast<Bone *>( getFirst() );
   Bone * b = new Bone( parent, 1 );
   b -> setStiffness( 5 );
   b -> setLength( 1 );
   b -> setXRot( 0, 0 );
   b -> setYRot( -90, 90 );
   b -> setZRot( 0, 0 );
   DBCommand *db = new DBCommand( b, ADD );
   db -> execute();
   tc -> addCommand( db );
   END();

}

void BoneModifier::slotAddYZ()
{
   BEGIN( "Adding XZ bone...", 1 );
   Bone * parent = static_cast<Bone *>( getFirst() );
   Bone * b = new Bone( parent, 1 );
   b -> setStiffness( 5 );
   b -> setLength( 1 );
   b -> setXRot( -90, 90 );
   b -> setYRot( 0, 0 );
   b -> setZRot( 0, 0 );
   DBCommand *db = new DBCommand( b, ADD );
   db -> execute();
   tc -> addCommand( db );
   END();

}

void BoneModifier::slotAddBall()
{
   BEGIN( "Adding XZ bone...", 1 );
   Bone * parent = static_cast<Bone *>( getFirst() );
   Bone * b = new Bone( parent, 1 );
   b -> setStiffness( 5 );
   b -> setLength( 1 );
   b -> setXRot( -90, 90 );
   b -> setYRot( 0, 0 );
   b -> setZRot( -90, 90 );
   DBCommand *db = new DBCommand( b, ADD );
   db -> execute();
   tc -> addCommand( db );
   END();
}

void BoneModifier::slotEnvelope()
{
   Bone::setMode( Bone::MODE_ENVELOPE );
   m_popup -> setItemChecked( mode_normal, false );
   m_popup -> setItemChecked( mode_ik, false );
   m_popup -> setItemChecked( mode_envelope, true );
   m_popup -> setItemChecked( mode_limits, false );
}

void BoneModifier::slotNormal()
{
   Bone::setMode( Bone::MODE_NORMAL );
   m_popup -> setItemChecked( mode_normal, true );
   m_popup -> setItemChecked( mode_ik, false );
   m_popup -> setItemChecked( mode_envelope, false );
   m_popup -> setItemChecked( mode_limits, false );
}

void BoneModifier::slotIK()
{
   Bone::setMode( Bone::MODE_IK );
   m_popup -> setItemChecked( mode_normal, false );
   m_popup -> setItemChecked( mode_ik, true );
   m_popup -> setItemChecked( mode_envelope, false );

}

void BoneModifier::slotLimits()
{

   Bone::setMode( Bone::MODE_LIMITS );
   m_popup -> setItemChecked( mode_normal, false );
   m_popup -> setItemChecked( mode_ik, false );
   m_popup -> setItemChecked( mode_envelope, false );
   m_popup -> setItemChecked( mode_limits, true );
}

void BoneModifier::slotSaveAffected()
{
   BEGIN( "Saving Affected", 1 );
   static_cast<Bone *>( getFirst() ) -> saveAffected( false );
   END();
}

void BoneModifier::slotSaveAffectedAndOffsets()
{
   BEGIN( "Saving Affected And Offsets...", 1 );
   static_cast<Bone *>( getFirst() ) -> saveAffectedAndOffsets( false );
   END();
}

void BoneModifier::slotResetAffected()
{
   BEGIN( "Resetting affected...", 1 );
   static_cast<Bone *>( getFirst() ) -> resetAffected( false );
   END();
}

void BoneModifier::slotSaveOffsets()
{
   BEGIN( "Saving offsets...", 1 );
   static_cast<Bone *>( getFirst() ) -> saveAffectedOffsets( false );
   END();
}

void BoneModifier::slotSaveAffectedR()
{
   BEGIN( "Saving affected recursively...", 1 );
   static_cast<Bone *>( getFirst() ) -> saveAffected( true );
   END();
}

void BoneModifier::slotSaveAffectedAndOffsetsR()
{
   BEGIN( "Saving Affected and Offsets recursively...", 1 );
   static_cast<Bone *>( getFirst() ) -> saveAffectedAndOffsets( true );
   END();
}

void BoneModifier::slotResetAffectedR()
{
   BEGIN( "Saving affected recursively...", 1 );
   static_cast<Bone *>( getFirst() ) -> resetAffected( true );
   END();
}

void BoneModifier::slotSaveOffsetsR()
{
   BEGIN( "Saving Offsets recursively...", 1 );
   static_cast<Bone *>( getFirst() ) -> saveAffectedOffsets( true );
   END();
}

void BoneModifier::slotToggleAffected()
{
   Bone::draw_affected = ! Bone::draw_affected;
   m_popup -> setItemChecked( draw_affected, Bone::draw_affected );
}

void BoneModifier::slotToggleEnvelope()
{

   Bone::draw_envelope = ! Bone::draw_envelope;
   m_popup -> setItemChecked( draw_envelope, Bone::draw_envelope );

}

void BoneModifier::slotToggleLimits()
{
   Bone::draw_limits = ! Bone::draw_limits;
   m_popup -> setItemChecked( draw_limits, Bone::draw_limits );
}

void BoneModifier::slotProperties()
{
   BEGIN( "Setting Properties...", 1 );
   CBoneDlg * dlg = new CBoneDlg( 0, "Modify Bone Properties", true );
   Bone * b = static_cast<Bone *>( getFirst() );
   Vector4 r;
   r = b -> getXRot();
   dlg -> setA( (int)r.y );
   dlg -> setB( (int)r.x );
   r = b -> getYRot();
   dlg -> setC( (int)r.y );
   dlg -> setD( (int)r.x );
   r = b -> getZRot();
   dlg -> setE( (int)r.y );
   dlg -> setF( (int)r.x );
   dlg -> setStiffness( (int) b -> getStiffness() );
   dlg -> setLength( (int) b -> getLength() );
   dlg -> setName( b -> getName() );
   dlg -> setNotes( b -> getNotes() );

   if ( dlg -> exec() )
   {

      b -> setXRot( dlg->getA(), dlg->getB() );
      b -> setYRot( dlg->getC(), dlg->getD() );
      b -> setZRot( dlg->getE(), dlg->getF() );

      b -> setStiffness( dlg->getStiffness() );
      b -> setLength( dlg -> getLength() );
      b -> setName( dlg->getName().ascii() );
      b -> setNotes( dlg->getNotes().ascii() );

   }

   delete dlg;
   END();
}

