/***************************************************************************
                         texturematerial.h  -  description
                            -------------------
   begin                : Wed Jan 19 2000
   copyright            : (C) 2000 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TEXTUREMATERIAL_H
#define TEXTUREMATERIAL_H

#include "texture.h"
#include <fstream.h>
#include <string>
#include <qcolor.h>

/**This is an encapsulation of material properties for OpenGL
rendering.  It includes both lighting/coloring parameters
as well as texturing.
  *@author Jon Anderson
  */

class Color
{
   public:
      Color( int _r = 0, int _g = 0, int _b = 0 ) {r = _r; g = _g; b = _b;};

      Color & operator=( QColor &rhs ) {r = rhs.red(); g = rhs.green(); b = rhs.blue(); return *this;};

      int r;
      int g;
      int b;
      float * toVector( float *v ) {v[ 0 ] = ( float ) r / 255; v[ 1 ] = ( float ) g / 255; v[ 2 ] = ( float ) b / 255, v[ 3 ] = 1; return v;};
};

class TextureMaterial
{
   public:
      TextureMaterial();
      ~TextureMaterial();
      /**Enable of disable texturing */
      void setTextureEnabled( bool b ) {enable_texture = b; dirty = true;};

      /**Sets up the current opengl context to use this material */
      void beginMaterial();
      /**If necessary, end the mode by disabling things */
      void endMaterial();
      void write( ostream &out );
      void read( istream &in );
      void readSimple( istream &in );

      void setSelected( bool b ) { m_selected = b; };



      string getName() { return name;};

      TextureMaterial & operator=( TextureMaterial &rhs );

   public:
      Color cAmbient;
      Color cDiffuse;
      Color cEmission;
      Color cSpecular;
      string name;
      Texture *texture;
      Texture *opacity;
      Texture *specularity;
      Texture *displacement;

      int shininess;
      int alpha;
      bool dirty;
      bool enable_texture;
      bool m_selected;
      int glId;


};

#endif
