/***************************************************************************
                         polyskin.h  -  description
                            -------------------
   begin                : Wed May 10 2000
   copyright            : (C) 2000 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef POLYSKIN_H
#define POLYSKIN_H

#include "subobject.h"

#include <vector>

class NurbsSurface;

class Mesh;

class Face;

class Spline;

/**This class constructs a 'skin' surrounding a list of selected
splines.
  *@author Jon Anderson
  */

class PolySkin
{
   public:
      PolySkin();
      ~PolySkin();

      Mesh * getMesh( vector<Spline*> &splines );
      NurbsSurface * getSurface( vector<Spline*> &splines );

      void setUseQuads( bool f ) {quads = f;};

      VertexList * getVertArray() { return sverts;};

   private:
      bool quads;
      VertexList *sverts;

};

#endif
