/***************************************************************************
                          transfromcommand.h  -  description
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef TRANSFORMCMD_H
#define TRANSFORMCMD_H

#include "command.h"
#include <Entities/entity.h>

/** A transform command encapsulates a request to transform an entity ( move or rotate).
  * if the entity is a subobject, it stores a pointer to the parent, a type, and an index instead.
  *@author Jon Anderson
  */

class TransformCmd : public Command  {
public: 
	TransformCmd(Selectable *_e);
	~TransformCmd();

	void begin();
	void end();

  /** Transform the entity to the old location. */
  bool undo();
  /** Transform the entity to the new location. */
  bool execute();
protected:
  Selectable *m_transformable;

  int m_type;
  int m_index;

	Vector4 old_pos;
	Quat old_quat;
	
	Vector4 new_pos;
	Quat new_quat;
	
	
	
	
};

#endif
