/***************************************************************************
                          transformcommand.cpp  -  description
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "transformcmd.h"
#include <Entities/subobject.h>
#include <Entities/object.h>

TransformCmd::TransformCmd(Selectable *_e):Command()
{
	if (  _e  -> isA( SubObject::TYPE ) )
	{
	  SubObject * s = static_cast< SubObject *>( _e );
	  m_transformable = s -> getParentObject();
	  m_index = s -> getParentIndex();
	  m_type = s -> getType();
	
	}	else {
	  m_transformable = _e;
	  m_type = -1;
	  m_index = -1;
	}
}
TransformCmd::~TransformCmd()
{
	
}

void TransformCmd::begin()
{
  Transformable * e;

  if( m_type == -1 ) {
    e = m_transformable;
  } else {
    e = static_cast<Object *>( m_transformable ) -> getSubObject( m_type, m_index );
  }
  old_pos = e -> getPosition();
  old_quat = e -> getOrientation();
}
void TransformCmd::end()
{
  Transformable * e;

  if( m_type == -1 ) {
    e = m_transformable;
  } else {
    e = static_cast<Object *>( m_transformable ) -> getSubObject( m_type, m_index );
  }

  new_pos = e -> getPosition();
  new_quat = e -> getOrientation();
}


/** Transform the entity to the new location. */
bool TransformCmd::execute()
{
  Transformable * e;

  if( m_type == -1 ) {
    e = m_transformable;
  } else {
    e = static_cast<Object *>( m_transformable ) -> getSubObject( m_type, m_index );
  }

	if( e == 0) {
		cerr << "Action nolonger doable..."<<endl;
		return false;
	}		

	e->setPosition( new_pos );
	e->setOrientation( new_quat );	
	
	return true;

}
/** Transform the entity to the old location. */
bool TransformCmd::undo()
{
  Transformable * e;

  if( m_type == -1 ) {
    e = m_transformable;
  } else {
    e = static_cast<Object *>( m_transformable ) -> getSubObject( m_type, m_index );
  }

	if( e == 0) {
		cerr << "Action nolonger doable..."<<endl;
		return false;
	}		

	e->setPosition( old_pos );
	e->setOrientation( old_quat );	
	
	return true;

}
