/***************************************************************************
                         modifier.h  -  description
                            -------------------
   begin                : Mon Apr 16 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MODIFIER_H
#define MODIFIER_H

#include "icontrol.h"
#include <vector>
#include <map>
#include <Math/vector4.h>
#include <Entities/entity.h>
#include <Entities/subobject.h>
#include <qobject.h>
#include <qmessagebox.h>


class TransactionCommand;

/**
  *@author Jon Anderson
  */

class Modifier : public IControl
{

      Q_OBJECT

   public:
      Modifier( int type );
      virtual ~Modifier();

      typedef map<Selectable *, Command *, less<Selectable *> > CommandMap;
      typedef CommandMap::value_type CommandPair;

      typedef vector<Selectable *>::iterator SelectionIterator;

      //overridden from IControl;
      virtual QPopupMenu * getPopupMenu();

      //overriddin from IControl;
      virtual void filterSelection( int *array, int n, int mode );
      virtual void transform ( Vector4 &, Vector4 & );
      virtual void mouseMove ( Vector4 &, Vector4 &, int );
      virtual void mousePress ( Vector4 &, Vector4 &, int );
      virtual void mouseRelease( Vector4 &, Vector4 &, int );
      virtual void keyEvent ( QKeyEvent * );

      virtual void draw();

      virtual void activate() = 0;
      virtual void deactivate() = 0;

      virtual void selectionEvent(){};

      void getSelectionCenter( Vector4 *p ) { *p = m_selection_center; };

      virtual void startTransform();
      virtual void endTransform();

      virtual void updateViews();
      virtual void updatePlaceLabel();
      Selectable * getFirst();

      /* Warning messages... */
      bool assertSelected( int n );
      bool assertSelectedExactly( int n );
      void warnNoneSelected( int n );
      void warnExactSelected( int n );

      void warnNotSameParent();

      void clearSelection();




   public slots:
      void slotSelectMode();
      void slotRotateMode();
      void slotMoveMode();
      void slotScaleFreeMode();
      void slotScaleUniformMode();
      void slotToggleMultiSelect();
      void slotToggleX();
      void slotToggleY();
      void slotToggleZ();

      void slotActivate();


   protected:

      void getCenter( Vector4 * );

      Vector4 m_selection_center;

      Vector4 m_press;
      Vector4 m_move;
      Vector4 m_release;

      vector<Selectable *> *m_selection;
      vector<Selectable *> m_clipboard;

      TransactionCommand *m_command;

      int m_modify_type;

      CommandMap m_cmds;


      QPopupMenu * m_axis_menu;
      QPopupMenu *m_allmenu;
      int menu_multiselect;
      int menu_x_axis;
      int menu_y_axis;
      int menu_z_axis;
};


#endif
