/***************************************************************************
                         keyframe.cpp  -  description                        
                            -------------------                              
   begin                : Sun Apr 25 1999                                    
   copyright            : (C) 1999 by Jonathan E. Anderson                   
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "keyframe.h"

Keyframe::Keyframe( int _time ) :
      channels()
{
   time = _time;
}

Keyframe::Keyframe( const Keyframe &kf ) :
      channels()
{
   //*this = kf;
   copy( kf );
}

Keyframe::~Keyframe()
{
}

void Keyframe::save()
{
}

void Keyframe::open()
{
}

void Keyframe::set( int s, const Vector4 &v )
{
   list<Channel>::iterator iter;

   for ( iter = channels.begin(); iter != channels.end(); iter++ )
   {
      if ( s == ( *iter ).m_channel_id )
      {
         ( *iter ).value = v;
         return ;
      }

   }

   Channel c( s, v );
   channels.push_back( c );
}


Vector4 Keyframe::get( int s )
{
   list<Channel>::iterator iter;

   for ( iter = channels.begin(); iter != channels.end(); iter++ )
   {
      if ( s == ( *iter ).m_channel_id )
         return ( *iter ).value;

   }

   Vector4 v( 0, 0, 0, 0 );
   return v;
}

bool Keyframe::operator ==( const Keyframe &s )
{
   return ( time == s.time );
}

bool Keyframe::operator <=( const Keyframe &s )
{
   return ( time <= s.time );
}

bool Keyframe::operator <( const Keyframe &s )
{
   return ( time < s.time );
}



Keyframe & Keyframe::operator=( const Keyframe &s )
{
   copy( s );
   return *this;
}

void Keyframe::copy( const Keyframe &s )
{
   // Need to clear each property.
   channels.clear();
   channels = s.channels;
   time = s.time;
}













